%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

# Advanced Troubleshooting / Debug Parameters

These parameters are listed here for completeness. Do not use them unless you understand what you are doing, or unless you are asked to for troubleshooting purposes. Some of them are harmless but others can cause improper functioning of Fatdog64.

%%nopot yes
## coldplug 

%%nopot no
Do hardware detection and driver/module loading as early as possible at boot-time.

This option is automatically enabled if you use the **net** parameter - it is required to load the network drivers (modules) before networking can be started.

%%nopot yes
## loadmodules 

%%nopot no
This parameter is the opposite of **blacklist**.

It tells Fatdog64 to load specific modules that are not automatically loaded, probably because they are not detected or because they have a conflict with others modules.

This can be used to load any module, although it is meant for loading modules required to access save devices (the device where the savefiles are located) - although if this is the case, **coldplug** may be a better option (at the cost of a slightly longer boot time).

The syntax is: **loadmodules=module1,module2,module3**  and so on.

Note: separate module names by commas, and there is no space in between.
If the modules are not required during boot time, don't use this parameter. Instead load modules from /etc/rc.d/rc.local.

Note: loadmodules takes precedence over blacklist.

%%nopot yes
## keepvar 

%%nopot no
/var and /usr/local/var are places where the system usually keeps logging messages and other run-time variables.

Without proper management, they can grown indefinitely large.

Fatdog64 handles this by deleting all files inside them during system start-up.
But sometimes the log files contain valuable messages that you want to review (especially if you have had a crash), so this parameter tells Fatdog64 to "keep the files in /var directory."

%%nopot yes
## earlyshell 

%%nopot no
Get a shell as soon as it is possible to do so.

You will be running in the busybox environment at the beginning of the init process, just after modules have been loaded (after loadmodules/coldplug are processed), but before anything else has been done.

Only /dev, /proc, and /sys are mounted.

This is in contrast with earlier Fatdog & Puppy Linux "pfix=rdsh", which launches the shell after the stackable filesystem has been constructed (see below).

Type "exit" to continue system startup.

Note: The shell you are running is not PID 1; you cannot switch_root inside it.

%%nopot yes
## lateshell 

%%nopot no
Get a shell just after the stackable filesystem has been set up.

This enables you to modify the root-to-be filesystem, for example during troubleshooting.

The root-to-be filesystem is located at /aufs/new_root.

You will still be running in the busybox environment, in the very final stages of the init process. After this, the system will switch the root to the stackable filesystem.

This option is roughly equivalent to the Puppy Linux "pfix=rdsh" boot option.
Type "exit" to continue system startup.

Note: The shell you are running is not PID 1; you cannot switch_root inside it.

%%nopot yes
## bbshell 

%%nopot no
Just like earlyshell and lateshell, except that you get the shell just before the basesfs parameter is processed. Only useful if you know what you are doing. (bbshell = before-basesfs-shell).

%%nopot yes
## bbhook=/path/to/file

%%nopot no
Source /path/to/file just before basesfs parameter is processed. (bbhook = before-basesfs-hook). bbhook is processed before bbshell. Only useful if you know what you are doing.


%%nopot yes
## showerr 

%%nopot no
Show verbose error messages on screen during system boot-up.

It is normal to see a lot of error messages, but most of them are harmless (or meaningless).

When this option is not used, these messages are redirected to /dev/initrd.err.

%%nopot yes
## debuginitrd 

%%nopot no
Trace the execution of initrd.

Output is shown to screen or saved to a file depending on the **showerr** setting above.

%%nopot yes
## DRV_DEBUG 

%%nopot no
Show the summary of modaliases processed. Use **DRV_DEBUG=verbose** to display all the modaliases as they are being processed.

This parameter only has effect when coldplug is being used.

%%nopot yes
## DRV_WAIT=n 

%%nopot no
Hardware detection (coldplug) is done twice (at least); **n** specifies how many seconds to wait between each round.

The default is zero.

This parameter only has effect when coldplug is being used.
