%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

Kernel command line parameters are parameters that you pass on to Fatdog64 during the boot process.

They are also known as "boot options".

Some of these parameters are understood by the Linux kernel; some are understood by Fatdog64 system scripts. They influence how Fatdog64 brings the system up and operates; they also control how the Linux kernel behaves. There are so many parameters (especially for the Linux kernel) that this page will only address some of the most important ones.

# Applying Parameters

These parameters must be passed on to Fatdog64 before the system boots up, during the boot-loading stage.

Boot loaders can be configured to pause and ask for parameters during boot up (like the one in the Fatdog64 Live CD/DVD), or you can put them in the configuration file.

For example, with the Fatdog64 Live CD/DVD, the system will display the Fatdog64 logo and pause for 5 seconds for you to key in any parameters.

Here, you can enter the parameters like this:
		boot: fatdog paramA paramB ... 
where "boot:" is the boot prompt displayed by the boot loader, "fatdog" is the operating system label understood by the bootloader (it has to be "fatdog" for the Fatdog64 Live CD/DVD), and "paramA", "paramB" etc are the parameters.

If nothing has been typed after 5 seconds, the system will continue to boot-up with the default parameters.

If you use GRUB, the parameters are passed on the **kernel** line. For example:
		root (hd0,0) 
		kernel /vmlinuz paramA paramB
		initrd /initrd
		
If you use syslinux and its friends, the parameters are passed on the **append** line. For example:
		kernel vmlinuz 
		initrd initrd 
		append paramA paramB
Note 1: parameters are **case sensitive**.

Most of them are in lower case, so if you specify them in upper case (capital letters), they won't work. Also remember that all parameters **cannot include spaces or colons**.

Note 2: For Windows users - the word **module** in Linux terms is roughly equivalent to what you usually know as **drivers** in Windows.

# Commonly Used Parameters

These are the commonly used parameters to tune system operation or to troubleshoot issues.

[Fatdog64 Parameters](boot-options-fd.md) 

[Linux Kernel Parameters](boot-options-linux.md) 

# Advanced Parameters

Advanced parameters are used to fine-tune system operation at a deeper level.
Once you are familiar with Fatdog64 basic operation, we recommend that you read this section.
At least read the savefile parameter - it is the most useful.

%%nopot yes
[savefile](boot-options-savefile.md) - [key](boot-options-key.md) - [net](boot-options-net.md) - [base](boot-options-base.md)

%%nopot no

# Advanced Troubleshooting / Debug Parameters

These parameters are listed here for completeness. Do not use them unless you understand what you are doing, or unless you are asked to for troubleshooting purposes. Some of them are harmless but others can cause improper functioning of Fatdog64.

[Advanced and Troubleshooting Parameters](boot-options-trouble.md)


