%%textdomain fatdoghelp
![ ](fatdog64.png)
# Screen Brightness controls not working. 

The sven keyboard daemon, which is in the [system tray](tray.md), calls a couple scripts to control the screen brightness. Unfortunately this varies a bit between computers.

There are three things that can go wrong with this.

**1.** Sven might not be configured to use the correct keys for your computer.

**2.** The two scripts that Sven calls (/usr/bin/brightness-up and /usr/bin/brightness-down) could be using the wrong file in /sys

**3.** The two scripts that Sven calls (brightness-up and brightness-down) could be using too low of a value to increase or decrease the brightness, so it's actually working but it doesn't seem like it because you have to hit the key a hundred times.

So the first thing to do is open a terminal and type:
		brightness-up
and then press Enter.

If it changes the screen brightness then it's probably problem 1.

If you get an error about file not found , then it's probably problem 2.

If it doesn't return an error, but nothing seems to happen, then it's probably problem 3.

The brightness-up script looks like this:


		#!/bin/ash   
		DEVICE= #radeon_bl0, acpi_video0, etc$ 
		DEVPATH=/sys/class/backlight 

		[ -z $DEVICE ] && DEVICE=$(ls $DEVPATH 2>/dev/null | head -n 1) 
		[ -z $DEVICE ] && exit 1 

		CURRENT=$(cat $DEVPATH/$DEVICE/actual_brightness)
		MAX=$(cat $DEVPATH/$DEVICE/max_brightness) 
		CURRENT=$(( CURRENT + 1 )) 
		if [ "$CURRENT" -gt "$MAX" ]; then CURRENT=$MAX; fi
		echo $CURRENT > $DEVPATH/$DEVICE/brightness 


For problem 3, you'll want to change CURRENT + 1 to maybe CURRENT + 100 and try again.

For problem 2, you'll need to replace /sys/class/backlight/acpi_video0/ with the correct path.

You'll also need to make the corresponding changes to /usr/bin/brightness-down.

For problem 1, you'll need to edit the Brightness down and Brightness up properties in Sven (right click and select Preferences).
