%%textdomain fatdoghelp
![ ](fatdog64.png)
# How to find firmware for your devices

Devices requires two things to work. First is the device drivers, and in Linux, "device drivers" is called as "kernel modules". Some devices, in addition to the drivers, also require what is called as "firmware". This "firmware" is basically the operating system for the microcontroller used in the device. Not all devices require firmware, and some can optionally use a firmware but can work without it.

Fatdog comes with a large collection of firmware, but there are always some specialised devices that we may have not included the firmware for. If you know you have the correct drivers but your devices are still not working, this is probably the case.

To check, open terminal and type "dmesg | grep -i firmware". If you see any indication that a firmware is not found, that's probably it and you need to hunt the firmware.

There are many places for firmware and unfortunately there isn't a single central repository for it. You just need to search for it. And then these links can become stale, disappear, or gets replaced. That's part of the fun, of course.

The links listed below are current as of 1 September 2020.

1. Your number one stop should be "linux-firmware". This has the largest collection of firmware (most of it should already be in Fatdog, but we may miss a few). All free-licensed firmware should be here: https://git.kernel.org/pub/scm/linux/kernel/git/firmware/linux-firmware.git

2. ALSA firmware: most soundcard doesn't need firmware, but some do. If your card is one of those, you may be able to find it here:  https://www.alsa-project.org/main/index.php/Main_Page (look for alsa-firmware).

3. Debian also has a lot of collection of non-free firmware blobs: https://packages.debian.org/source/sid/firmware-nonfree and http://deb.debian.org/debian/pool/non-free/f/firmware-nonfree/firmware-nonfree_20200721.orig.tar.xz

4. ath10k firmware old and new: https://github.com/kvalo/ath10k-firmware

5. Intel Wifi firmware old and new: https://www.intel.com/content/www/us/en/support/articles/000005511/network-and-i-o/wireless.html

6. Libertas (Marvell) Wifi firmware: https://packages.debian.org/sid/firmware-libertas

7. Netronome LAN / Wifi firmware: https://fedora.pkgs.org/31/fedora-updates-x86_64/netronome-firmware-20200721-110.fc31.noarch.rpm.html

8. Silicon Labs Wifi firmware (rs9113_wlan_qspi.rps) https://github.com/SiliconLabs/RS911X-nLink-OSD/tree/master/Firmware

9. Some rare firmware for realtek Wifi chips: https://github.com/lwfinger/rtl8723au_bt/

10. Firmware for TV Tuner using Siano chips: https://debian.pkgs.org/sid/debian-nonfree-armhf/firmware-siano_20200721-1_all.deb.html

11. Other IPTV firmwares: https://packages.debian.org/sid/firmware-ivtv

12. xc3028L-v36.fw: http://www.steventoth.net/linux/hvr1400/xc3028L-v36.fw

13. xc3028-v27.fw: http://www.steventoth.net/linux/hvr1500/xc3028-v27.fw

14. http://www.steventoth.net/linux/ has firmwares for other obscure devices too.

15. comedi/jr3pci.idm: http://www.comedi.org/download/comedi-nonfree-firmware-2007.06.22.tar.gz

