%%textdomain fatdoghelp
![ ](fatdog64.png)
# Where to get rEFInd boot loader

rEFInd is a very nice boot loader / boot manager written by Rod Smith.
It's official home page is [http://www.rodsbooks.com/refind/](here).

Fatdog64 uses rEFInd as its primary boot loader; and an official copy
of rEFInd is included in the Fatdog ISO.
You can always find it at **/usr/share/refind-bin-xxxx/refind**
(the "xxx" refers to its version number, it's version 0.11.3 as of Fatdog64 800).
This is often not the latest version; if you really need the latest
version it is available from rEFInd's download page.

Alternatively, you can also use and get the version of rEFInd that is
used to boot the Fatdog ISO. This is usually an even older version
than what you find above, so it's not recommended - but if you want to,
you can get it from **efiboot.img**.
This file is inside the Fatdog ISO.
All you need to do is (double-)click it, and a new ROX-Filer window 
will open.

For older version of Fatdogs (older than 720), here are the steps to do it.

 * Make sure there is nothing mounted on /mnt/data
 * On ROX Filer, click (or double-click) Fatdog ISO to open its contents.
 * Within that ROX-Filer window that shows the ISO contents, right-click and choose "Terminal Here".
   A new terminal window will open.
 * From that terminal: run the command `mountpoint /mnt/data` to check it.
   Make sure it says it is **NOT** a mountpoint.
 * Mount the efiboot.img read only: run the command `mount -o ro efiboot.img /mnt/data`.
   When done, open a ROX-Filter window by running `rox /mnt/data.`
 * The ROX-Filer window on `/mnt/data` contains rEFInd boot loader.
   Copy it as necessary.
 * When done, close the ROX-Filer `/mnt/data`.
 * From the same terminal in the previous steps, run command `umount /mnt/data`
 * Then close the terminal.
 * Close the Fatdog ISO.

 Note: If you choose to install refind from efiboot.img, please note "drivers_x64"
 (or drivers for older Fatdogs) folder is located at the top folder, not inside EFI/Boot.
 In this case, these drivers are not activated and are not loaded at boot.
 If you need to  use any of these, you will need to move "drivers_x64" and place it inside EFI/Boot.

For more information please refer to the refind website.
Or, if you have devx loaded, a copy of the information is available in /usr/share/doc/refind-xxxx.
