%%textdomain fatdoghelp
![fatdog](fatdog64.png) 

# Fatdog64 64-bit GNU/Linux Operating System


Fatdog64 is an all 64-bit version of GNU/Linux built from source packages for Intel/AMD systems. Despite its 'fat' name (and a 'fat' dog icon), Fatdog64 is a small, fast, yet versatile  operating system targeted for the desktop home users. 

Run it in *LiveCD mode*, *LiveUSB mode*, install it 'frugally' to *your harddisk* or SSD, or run from and *save changes to a multi-session DVD*. Use it in '*throwaway mode*' (persistent data is kept - all things are wiped out after you reboot), or *persist your personal settings* and configurations across reboots using savefile or save directory.

Fatdog64 installation requires ***no dedicated partition*.** Fatdog64 will happily use existing partitions of other operations systems to store its system files and savefiles - it can even use existing NTFS partitions.

What's the obsession with 'Fat'? Why the name 'Fat' dog?

Fatdog64 was originally derived from [Puppy Linux](http://puppylinux.org), yet another fast, small and versatile Linux operating system for 32-bit Intel/AMD systems.
Fatdog Linux (the precursor to Fatdog64) started as an "extended" or "fatter" derivative of Puppy Linux, including extras such as the complete Xorg, inclusion of large packages such as Firefox, Pidgin, Gimp, Kino, etc that made it larger (in terms of size) than Puppy Linux.
Over the time, Fatdog migrated to support 64-bit platform (hence Fatdog64 name) and grew  became an independent distribution of its own - while striving to keep the original spirit of Puppy Linux of being small, fast, and versatile.
For a fuller history [click here](http://distro.ibiblio.org/fatdog/web/history.html).

Fatdog64 800 series - the latest iteration of Fatdog64 - is hand-built based on recipes from [Linux From Scratch](http://linuxfromscratch.org), version 8.2.

## Additional Software

Additional software for Fatdog64 comes in two forms: regular software packages that needs to be installed to your system, and bundled prepared 'SFS' packages that you can load/unload on demand.

### Regular packages

Starting from version 700, Fatdog64 regular software packages are packaged in Slackware-style tarballs, in fact, we use Slackware package management system (pkgtools) for handling local packages.
Fatdog64 uses Gslapt from www.jaos.org as the user-friendly GUI front-end for easy access to package repository: viewing, downloading, and and installing packages (Gslapt replaced custom-brewed Fatdog Package Manager 'FPM' and Puppy Package Manager 'PPM' used in earlier versions of Fatdog64)

You can of course download packages directly from [here (ibiblio)](http://distro.ibiblio.org/fatdog/packages/700), or one of ibiblio's many mirrors.

**Note: Do not use Puppy pet packages in Fatdog64, Puppy's 32bit packages won't work.**

### SFS Packages

An 'SFS' package is a collection of packages, pre-installed in a SquashFS compressed  filesystem' which will be 'merged' with your filesystem when you use it. SFS packages are usually commonly provided for a collection of software that are tightly integrated to each other; or packages which are very large (SFS helps because the packages in it are compressed. With regular packages, they get expanded during installation).

There are common packages that are *always* provided in SFS format, for  example the fd64-devx_xxx.sfs package is the "development" package and contain GCC compiler, perl, python, headers, version control systems (git, svn, etc) - everything you need to compile stuff.

Fatdog64 kernel sources are provided in kernel-source-x.y.z.sfs (where x.y.z denotes the kernel version) - so you can build your own custom kernel (and kernel modules) too if you need to.

To use SFS packages, download it from [here (ibiblio)](http://distro.ibiblio.org/fatdog/sfs/700) or its mirrors and put it in /mnt/home, then launch **System SFS Loader** (from **Fatdog64 Control Panel**, the **System** tab).
From there, choose the SFS you want to load.

The loading can be done for just one time, or permanently at each boot time.
Or you can use **SFS Manager** (also from Fatdog64 Control Panel) to download and activate the SFS at the same time.

Source packages used to build Fatdog64 can be found [here](http://distro.ibiblio.org/fatdog/source/700)].

## Internet

Wired internet is automatically configured using dhcp.

Wireless internet can be configured by clicking the ![Connect](wpa_gui.png) icon. 

If you need to use static IP, use the Network Wizard in the Control Panel (and remember to disable WPA GUI).

## Useful Links

[Puppy Linux Discussion Forum.](https://forum.puppylinux.com/) This is the main forum for Puppy Linux. Fatdog64 posts have its own section in the forum.

Older posts about Fatdog64 can be found in [Puppy Linux old forum](http://oldforum.puppylinux.com/puppy), and are usually found in the Puppy Projects sub-forum.

Fatdog was initially derived from Puppy Linux and thus were part of the Puppy Linux family and community. Fatdog64 posts are usually found in the Puppy Projects sub-forum.

[Frequently Asked Questions](index.md Fatdog64)

[Info on the latest Fatdog64 release.](http://distro.ibiblio.org/fatdog/web/latest.html)

## Contributors

While Fatdog64 is primarily maintained and developed by "*kirk*" and "*jamesbond*", "*SFR*" and "*step*", there are many people who have contributed packages, ideas, applications, scripts, bug testing, artworks and many other things over the years.

The following list is just a small, non-exhaustive subset of the contributors, in no  particular order: *01micko, rcrsn51, billtoo, WillM, zigbert, L18L, SFR*, and many others.

Fatdog64 logo is contributed by AFG Sinaulan ("afgs" from Puppy Linux old forum). Original images [here](http://oldforum.puppylinux.com/puppy/viewtopic.php?p=425510#425510).
