%%textdomain fatdoghelp
![ ](fatdog64.png)
# Humongous initrd

Fatdog uses what is called in Puppy Linux terms "humongous initrd" (see [here](http://www.puppylinux.com/download/release-2.16.htm) and [here](http://oldforum.puppylinux.com/puppy/viewtopic.php?t=18421)).

Basically what it means is that there are only two (2) files needed to boot Fatdog, which are **vmlinuz** and **initrd**, instead of the usual three (3) (or more): **vmlinuz**, **initrd** and **base.sfs** (puppy.sfs, zdrv.sfs, adrive.sfs etc).

The **base.sfs** file still exists in Fatdog, but it is contained within the **initrd**; thus you can't see it. It also causes the initrd to swell: initrd's size is commonly around 3-5 MB, but in Fatdog it is about 425-450 MB because it contains the **base.sfs** - hence the name "humongous".

## Why use humongous initrd over Puppy's traditional 3-file setup?

**1)** Faster boot on harddisk frugal install.

**2)** Two file installation makes is very easy to boot Fatdog remotely using PXE.

**3)** Easier booting on exotic media - as long as the bootloader can load vmlinuz and initrd (which most Linux bootloaders are supposed to do), then Fatdog can run.

Of course, like anything else, the "faster boot" part depends on your BIOS and your hardware.
It is generally faster to use humongous initrd on harddisk frugal install but it isn't always so.
Humongous initrd may be slower to boot on other kinds of setup / install devices, too (though again, not always).

## Reasons for preferring the standard 3-file setup

You may have other reasons for preferring the standard 3-file setup:

- You're using an optical disc with multisession, and you find the boot time slow.

- You're booting from a USB flash drive or an SD card, and you find the boot time slow.

- You cannot install humongous initrd because of limited available space in the boot partition (e.g. UEFI boot partition). In this case, you can put a **vmlinuz** and small **initrd** in the UEFI boot partition, and put the **base.sfs** elsewhere.

## Converting the humongous initrd back to a small initrd

Fatdog supports converting the humongous initrd back to a small initrd, extracting the base.sfs in the process and reverting to the standard 3-file setup.  There are a number of ways to do it:

### Fatdog Installer

You can use Fatdog Installer.
If you have enough RAM (2 GB or more), it will offer to use either standard initrd or small initrd.

### Remaster

You can remaster Fatdog to create an ISO with a small initrd.

%%nopot yes
### fatdog-split-initrd.sh

%%nopot no
You can use the command line tool **fatdog-split-initrd.sh**. Run the command in a terminal to see the options.

Of special note: the **tmpdir** (temporary directory) used by the tool by default is /tmp,  **If you have less than 2 GB of RAM and you don't use swap, you'd better specify a different location or Fatdog can lock up due to running out of memory when doing the splitting**.

### Simplest Method

Or, if you only want to get a smaller version (not the smallest):

- Extract only the **fd64.sfs** by clicking (in ROX) on your installed **initrd** (this should open it up).

- Move **fd64.sfs** outside to a place accessible by the bootloader (perhaps the same location as vmlinuz and initrd itself)

- re-pack the initrd by clicking **repack-initrd.sh.**.

- Please remember to use the [basesfs parameter](boot-options-base.md) in your bootloader to tell Fatdog where to find the basesfs.

Usually setting it to **basesfs=local** or **basesfs=local:/path/to/fd64.sfs** will do (or you can specify the actual device location like **basesfs=device:sda7:/path/to/fd64.sfs** - this will be faster since it means Fatdog doesn't have to search for the base.sfs).


## Parting words

Will using a small initrd improve your boot speed?

Perhaps.

There is no definite answer.

You just need to give it a try.

---

Note: **base.sfs** is a generic term for Fatdog's system SFS.

Starting from Fatdog64 700, the base sfs is simply named **fd64.sfs**; there is no version number attached anymore.

----


## Nano Initrd

On Fatdog64 720 onwards, in addition to the standard huge initrd, Fatdog64 also comes with a small initrd that we dub **nano initrd** (the actual filename of this initrd in the ISO file is **initrd-nano**), to save the effort of making a small initrd as explained above.

This small initrd is called "**nano**" because it is the smallest variant; it is smaller than what can be produced by the above manual methods. It is also the least flexible and has the fewest features and least hardware support, because there are also no additional drivers in it. You can only use this initrd if you're certain that (as far as booting is concerned) your hardware is supported by the kernel without any additional modules.

To work, this nano initrd still needs the huge initrd; in fact, the only thing it does is to find the location of the huge initrd and then load it up. However, because the loading is done by the Linux kernel, this is usually much faster than the bootloader + BIOS combination. The base sfs loaded by nano initrd will stay in the memory just like with the normal huge initrd.

In order to use the nano initrd, you need to do two things:

**1)** In your bootloader configuration, where you usually specify "initrd", use "initrd-nano". But remember to keep "initrd" handy and remember its location.

**2)** In your bootloader configuration, where you specify kernel parameters / boot parameters / boot options, you need to add the option "mergeinitrd" to tell nano initrd where to find the huge initrd. You can read more details about this parameter [here](boot-options-base.md).

**Note**: nano initrd is relatively new and is not well tested and supported. It works.  However, some of Fatdog64's tools (remasters, installers) may not work correctly with it. If you encounter any unexpected behaviours, please report them in the forum and we will do what we can to improve the situation.



