%%textdomain fatdoghelp
![ ](fatdog64.png)
# How to compile a kernel module for Fatdog64

If you want to rebuild a kernel module because you need to add a patch to it, or maybe it was not built with the rest of the modules, this is how to do it.

Here is an example.
Let's say I found a patch for the kernel module named appletouch that fixes some problem I have with my touchpad.

## Step 1

You need to have both the fd64-devx_xxx.sfs file and the kernel-source-x.x.x.sfs installed.

To do that, place the fd64-devx_xxx.sfs and kernel-source-x.x.x in /mnt/home, then use the System SFS Loader to load them.

Note that the xxx in fd64-devx_xxx should be replaced with the version of Fatdog64 you are running and the x.x.x in kernel-source-x.x.x corresponds to the kernel version you are running.

To find your current kernel version open a terminal and type:
		uname -r

## Step 2

		cd /usr/src/linux-x.x.x/drivers/input/mouse

## Step 3

Apply the patch.

## Step 4

		make -C /lib/modules/`uname -r`/build M=`pwd` appletouch.ko

Put **uname -r** and **pwd** inside backticks.

## Step 5

Replace /lib/modules/x.x.x/kernel/drivers/input/mouse/appletouch.ko with the one just built.

---

If you just need to compile a driver that you've downloaded, all you need to do is have the devx.sfs file installed and follow the directions that came with that driver.
