%%textdomain fatdoghelp
![ ](fatdog64.png)
# How to use a different kernel

These instructions are for using one of the pre-packaged Fatdog kernels,
replacing the current one that comes with your version of Fatdog.
If, instead, you just want to add some additional kernel modules you've
built yourself, or if you want to compile a totally new kernel, please follow
the instructions in [here](initrd.md) to rebuild and replace the
kernel-modules.sfs in initrd.

There are a couple ways to use a different kernel.
First go [here](http://distro.ibiblio.org/fatdog/kernels) and download vmlinuz-x.x.x and kernel-modules.sfs-x.x.x, where x.x.x is the kernel version that you want.
Vmlinuz is the actual kernel and kernel-modules.sfs contains the kernel modules (drivers) that are built to work with it.

## Preferred method 

Replace the original kernel-modules.sfs in the initrd with the one you downloaded:

### Step 1

In ROX, click on your initrd file.

After a while the initrd will be extracted into a working folder and a new ROX window will open.

### Step 2

Replace the kernel-modules.sfs with the one you downloaded.

**Make sure it's named "kernel-modules.sfs"**.

### Step 3

Click on repack-initrd and the initrd will be updated.

### Step 4

Replace the original vmlinuz with the one you downloaded.

**Make sure it's named "vmlinuz"**

## Alternate method

Using hard drive install booting with grub:

### Step 1

Copy vmlinuz-x.x.x to the same place as your original vmlinuz.

### Step 2

Rename kernel-modules.sfs-x.x.x to kernel-modules.sfs then click on it to mount it.

A ROX file browser window will pop up.

### Step 3

From the mounted kernel-modules.sfs copy lib/modules/x.x.x to your system /lib/modules/.

### Step 4

Then you can add a new entry for grub in menu.lst, just like your current entry but with the kernel named vmlinuz-x.x.x.

### Step 5

Reboot using your new kernel.

---

You can also compile a new kernel by downloading the source from [www.kernel.org](https://www.kernel.org/), installing the devx sfs, and compiling.
