#!/bin/dash

# usage: $0    # stdin/stdout filter
# File MAP_MD_TO_HTML must be maintained! See below.

# Exclude from HTML output:
# - mdview's %% directives starting in column 1
# - any line that matches __rm__
grep -Ev '^%%[[:alpha:]]|__rm__' - |

# Convert to HTML
lowdown -s -T html - |

# File MAP_MD_TO_HTML must be maintained.
# Column 1 is the .md file name, column 2 its .html counterpart. Other columns ignored.
# We have the following mappings:
# - one-to-one,  e.g. home.md <-> home.html
# - many-to-one, e.g.  boot-options-*.md -> boot-options.html
# - one-to-none, e.g.  localize.md -> localize.md because !exist localize.html
# - none-to-one, e.g.  faqs.html because !exist faqs.md -> faqs.html
# - one-to-many we don't have and they don't matter.
# Only the first two cases need to be maintained at least for the markdown
# links that are included in the managed markdown files.
# The list of managed files is in the Makefile (variable HTMLS).

# Inject LOGO and stilesheet, and
# map .md links to their .html counterparts
gawk \
	-v LOGO="<img src=\"fatdog.png\" height=\"100\">" \
	-v MAP_MD_TO_HTML="./md--html.tsv" \
'#{{{gawk
# Load table that maps .md files to .html files
# It is not a perfect one-to-one mapping.
BEGIN {
	fs = FS
	FS = "\t"
	while(0 < (getline < MAP_MD_TO_HTML))
		md_to_html[$1] = $2
	close(MAP_MD_TO_HTML)
	FS = fs
}
/<\/head>/ && !did_head{
	print "<link rel=\"stylesheet\" type=\"text/css\" href=\"fatdog.css\">"
	print
	did_head++
	next
}
/<body>/ && !did_body {
	print
	print "<div id=\"container\">"
	next
}
/<\/body>/ && !did_body {
	print "</div>"
	print
	did_body++
	next
}
/<h1 / && !did_h1 {
	sub(/>/, ">"LOGO)
	print
	did_h1++
	next
}
# <a> tag: replace .md targets with .html targets
# (lowdown prints an <a> tag on a single line)
/<a[^>]+href="[^"]+\.md"[^>]*>/ {
	n = patsplit($0, tag, /<a[^>]+>/, sep)
	s = sep[0]
	for (i = 1; i <= n; i++) {
		t = tag[i]

		# extract href value
		p = index(t, "href=\"")
		q = index(substr(t, p + 6), "\"")
		href = substr(t, p + 6, q - 1)

		# map .md filename to .html filename
		if (href in md_to_html)
			href = md_to_html[href]

		# rebuild the tag
		tag[i] = substr(t, 1, p + 5) href substr(t, p + q + 5)

		s = s tag[i] sep[i]
	}
	print s
	next
}
{
	print
}
#gawk}}}'

