title: Primer for Puppy Linux Users  
date: 2020-09-09  
homepage: <http://distro.ibiblio.org/fatdog/web/>  

<!--
YAML section above - unfortunately, mdview will show it, but it's low noise.
Must leave an empty line between the YAML and whatever is the actual document content.

*** Authors take notice ***
Exactly two spaces at the end of a line force a hard line-break.
This document's markdown is greater than mdview's markdown.
This document is converted to HTML with ./make-html.sh.
-->
%%textdomain fatdoghelp
![__rm__](fatdog64.png)

[Go to general index](index.md)

# Primer for Puppy Linux Users

So you are a Puppy Linux user who wants to give Fatdog Linux a try.  Welcome to the _Fatdog Primer for Puppy Linux Users_!

Fatdog is different from Puppy.  While many concepts behind both are the same, the commands they each use are different.  Some behaviour is also slightly different.

Fatdog [was born in 2008→](http://distro.ibiblio.org/fatdog/web/history.html) as a derivative of Puppy Linux.  Since then it has has grown to become an independent 64-bit Linux distribution that maintains the Puppy spirit but is not Puppy.  Your valuable Puppy knowledge is still valued.  However, some of your Puppy tricks are not going to work with Fatdog. Some could even be counterproductive.  So, read this help document to avoid some common pitfalls for Puppy users, and enjoy your Fatdog ride.

**Document Navigation Tip**

This primer is written as a single file with lots of hyperlinks to the details.  Due to limitations of the document viewer, hyperlinks can only jump to the top of a linked document -- the middle or any other location is not possible.  Therefore, we use the following formatting convention; a link label that starts with character "▶" spells out the actual heading of the target section/paragraph you are supposed to read. So, after clicking such a link scroll down to the heading that matches the label then start reading.

The "→" character at the end of a link label indicates an external link.

When we refer you to use the _Fatdog64 Control Panel_ click the ![flower](controlpanel.png) icon in the desktop panel to start the control panel.
Think of Fatdog's Control Panel as Puppy's first-run wizard plus a bunch of other setup and system tools grouped in the following categories:
Localisation, Desktop, Sound, Network, System, Utilities and Updates.

## Getting Started -- Possible Issues

### Boot

[Fatdog's boot options](boot-options-fd.md) differ from [Puppy's→](http://wikka.puppylinux.com/BootParametersPuppy?redirect=no):
only `pkeys` and `pfix=nox` carry over from Puppy to Fatdog.  The others either do not apply to Fatdog or have been expanded and renamed to avoid collisions.  Some cheatcodes:

* `pfix=ram` _is_ `savefile=none`

The Fatdog ISO includes two initrd files, namely, `initrd` and `initrd-nano`. Initrd embeds the Fatdog system SFS file and is huge.  [Initrd-nano](huge-initrd.md) is much smaller for a reason.

> If Fatdog boots slowly on your machine (or it does not boot, or the cursor just blinks), boot with `initrd-nano` and add `mergeinitrd1=local:/path/to/initrd` to the boot options [▶mergeinitrd{n}](boot-options-base.md).  Here's a grub boot entry template for this case.

        title Fatdog
        uuid xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        kernel /fatdog-directory/vmlinuz
        mergeinitrd1=local:/fatdog-directory/initrd
        initrd /fatdog-directory/initrd-nano

Fatdog regards any system with less than 2GB RAM a low-RAM system.

> If your low-RAM system does not boot or the kernel panics while booting add `rootfstype=ramfs` to the boot options.

After the kernel boots and before Fatdog kicks in, the system is initialized by _Bulldog_ -- in itself a specialized mini-OS that leaves the stage when Fatdog is fully initialized.

> If boot fails showing "bulldog login", and `initrd-nano` is used, and boot files are located on USB media, add `waitdev=5` to the boot options.

### Installation

Fatdog has many installers! We have BIOS installers, UEFI installers, manual installation steps, contributed scripts on the forum, and so on.  Use one of the supported methods to install the system, _including for a frugal installation_:

* frugal [▶Harddrive](harddrive.md)
* frugal [▶Hard drive (frugal) installation of Fatdog64 on a computer with UEFI and secure boot](uefi-harddrive.md)
* BIOS installer [▶Guided Installation](harddrive.md)
* UEFI to a [flash drive](uefi-flashdrive.md)
* UEFI to a [flash drive (alternative method)](uefi-flashdrive2.md)
* UEFI to a [harddisk when UEFI firmware supports multiple boot loaders](uefi-harddrive.md)
* UEFI to a [harddisk when UEFI firmware does not support multiple boot loaders→](http://lightofdawn.org/wiki/wiki.cgi/SonyLinuxUefiBoot)
* UEFI and BIOS for [Windows-only: LICK installer](uefi-lick.md)

The BIOS and UEFI installers can be started from the Fatdog64 Control Panel's Utilities tab:

* _Fatdog64 Installer_ for BIOS computers
* _Fatdog64 UEFI Installer_

Note that Fatdog installers do not write an entry in your bootloader's configuration file.
We do not because if it fails your whole system will not be bootable.
The installer will output a skeleton `grub` entry that you can cut and paste to your existing grub configuration file.
We also provide the following tools to assist you in constructing the correct boot entry:

* _Savefile Argument Builder_ in Fatdog64 Control Panel Utilities
* _Grub4dos bootloader config_ in Fatdog64 Control Panel Utilities

### Installing Your Own Way

If you prefer to use your Puppy and Linux tricks to install Fatdog read the following FAQs first.

**Q:** I don't trust installers. I already have a boot loader in my disk/USB stick.  I install puppies by opening the ISO and copying the files to a subdirectory and editing `menu.lst` or `grub.cfg` myself. Can I do that with Fatdog?

**A:** Sure.

* You only need two files: `vmlinuz` and `initrd`, and optionally a third file, `initrd-nano` (explained above) if you experience slow boot issues.
* Your usual puppy boot cheatcodes will not work, however, so make sure you read above the common pitfalls when you install in this way.

**Q:** I want to install Fatdog as a full install.

**A:** It is not supported but it is possible.
See [▶Unsupported installation options from previous Fatdog64 versions](harddrive.md).

### Savefile and Savedir

Fatdog fully supports savefile and savedir, a.k.a. savefolder.  To save to a folder make sure to select that option when you go through the savefile creation dialog at the end of your first session.

So you installed Fatdog by copying the ISO to a USB stick with `dd` and now you can't create a savefile on the USB stick (Fatdog complains about write errors)?
This happens because the ISO filesystem is a read-only file system so `dd` created a read-only partition on the USB stick.

> Use `fix-usb.sh` located in the ISO

You created a savefile and no matter what you do now you can't make Fatdog load it -- even if you do specify `pmedia`, `psubdir`, `pdev1`, `psavemark`, etc. all to no effect?

> Fatdog uses different boot codes. Specifying Puppy boot codes is harmless but has no effect.

> Use boot option [▶savefile](boot-options-savefile.md) instead to specify the savefile location.

> Or use the _Savefile Argument Builder_ in Fatdog64 Control Panel Utilities.

> Or the _Fatdog64 Savefile Tool_ in Fatdog64 Control Panel System.

> Or tell Fatdog to look at directories more deeply with `search=2` (2 directories deep) or `search=3`.
By default Fatdog looks at top directories only (1-level deep).

You did the above but Fatdog still can't find the savefile?

> If the savefile is on USB add `waitdev=5` to the boot options.

You did the above but Fatdog still can't find the savefile?

> If you renamed the savefile/savedir away from the default name `fd64save.ext4`,
then you need to use the `savefile` boot option. See above.

> But if you renamed the savefile as `fd64save.backup` then Fatdog will find it and ask you to load either your backup or the correct savefile.
This happens because Fatdog recognises all the names that start with `fd64save.`.

> Rename your backup as `backup-fd64save.ext4` instead so Fatdog will not recognise it and will load the main savefile.

---

If none of the above remedies worked, head to the forum and post a help request in the Fatdog sub-forum or support thread.

---

### First-Time Setup

You ask, where is the first-run wizard? How can I setup anything without it?

> Use the _Fatdog64 Control Panel_ to configure most aspects of the system.
Start the control panel from the Fatdog menu » Setup entry or click the ![flower](controlpanel.png) icon in the desktop panel.

You can't find how to connect to the Internet. You expected to be greeted by a network connection wizard.

> Fatdog has _Network Tool_ a unified tool to establish and manage wireless and wired connections.
Puppy's tools _SNS_, _Frisbee_ and _Network Setup_ are not available.

Network Tool is automatically started and sits in the icon tray all the time. Click its icon to access it.
The icon may look like this
![connected network icon](network-error.png) -- when no connection is active (no network)
-- or like this
![disconnected network icon](wpa_gui.png)
-- when a connection is active.

> _Network Tool_ is explained [here](Networking.md).

**GOTCHA**  Fatdog64 Control Panel Network includes a _Network Setup_ applet.  __This is not the Network Tool__.
It is a different tool with a text-based user interface.  It is useful in some special cases but we do not discuss it here.

So, click the Network Tool icon and proceed to configure your wireless and/or wired adapter.

If you plug in a wireless adapter (dongle) after the system has booted, you need to restart the connection before that adapter can be used.

> Right-click the network tool icon and select "Restart Connection".

If your system has two or more wireless adapters use _Wireless Antenna_ to switch between multiple adapters.

> _Wireless Antenna_ can be found in Fatdog64 Control Panel Network.


If you have a Broadcom network adapter and in Puppy Linux you have to use the proprietary "wl" driver to connect, it will be the same in Fatdog Linux.

> To enable the "wl" driver start _Fatdog64 Control Panel_, click the System tab, double-click the "Manage Servers and Services" icon to start the _Fatdog64 Service Manager_; when the Service Manager window opens, scroll down the list to the service named "BC-wl", click its name to select/highlight its row, and click the "Enable" button, then close the dialog and reboot your system.

## Using the System -- Possible Issues

### SFS Files

If you are looking for:

* the SFS equivalent to `pup_xxx.sfs` -- it is named `fd64.sfs`; it is inside `initrd` by default
* the `zdrv.sfs` -- it is named `kernel-modules.sfs`; it too is inside `initrd` by default
* `adrv`, `ydrv`, `zdrv` -- we do not have them; these names carry no special consideration in Fatdog.

If you try renaming an existing SFS of yours to `adrv.sfs` or `ydrv.sfs` to get it automatically loaded at boot time, it will be ignored.

> Load it with the [▶extrasfs](boot-options-base.md) boot option
or use _System SFS Loader_ started either from the Fatdog64 Control Panel System tab
or from a console/terminal shell by entering the command `load_sfs.sh`.

_System SFS Loader_ is the equivalent of Puppy's SFS Load.
Unlike the latter, _System SFS Loader_ does not setup menus, add symbolic links, launch programs automatically, and so on.
It just loads/unloads an SFS.

Fatdog supports running an "install script" when an SFS file is loaded.
The install script is embedded inside the SFS.  Ask on the forum about this feature if you need to use it.

Whether you use boot option `extrasfs` or you use the System SFS Loader,
_Fatdog loads all SFS files above the base SFS_ [details](filesystem.md).
Fatdog's `fd64.sfs`, the base SFS, is always at the bottom.

By contrast, Puppy loads `adrv`, `ydrv` etc. above `pup.sfs`, the base SFS in Puppy, and all other SFS files below `pup.sfs`.

### Packages

Puppy's Package Manager (PPM) is called _Gslapt Package Manager_ in Fatdog.  You can find it in Fatdog64 Control Panel System.
It taps into the Fatdog package repository allowing you to download and install/uninstall packages and their dependencies.

In the same tab you will also find the _SFS Manager_, which can be used to download and load various SFS files, including the DEVX, NLS, kernel sources, and many others.

So you can't find the package you need in Fatdog repositories. What are your options?

> You can try converting a `pet` package.  This is Puppy's native format.  Fatdog's own package format is called `txz`.
To convert a pet package to txz format right-click the pet package icon in ROX-Filer and select "Convert to New Package Format".
This will create a txz package alongside the pet package.
Give the conversion process enough time to finish then install the package with right-menu click "Install Package".
**There is no guarantee** that the converted package will run on Fatdog.  Some dependencies could be missing, etc.

> You can try converting a `deb` package.  This is Debian's/Ubuntu's native format.
After downloading the right package right-click "Convert to Fatdog Package Format", the rest is the same as the `pet` package case.
To convert a pet package to txz format right-click the pet package icon in ROX-Filer and select "Convert to New Package Format".
**There is no guarantee** that the converted package will run on Fatdog.  Some dependencies could be missing, etc.

**Q:** I see that  Fatdog uses TXZ packages. Will I have more luck using Slackware packages instead?

**A:** Maybe. Fatdog uses the same TXZ format as Slackware, but it is not a Slackware derivative.
It does not re-use Slackware packages. We build all our packages ourselves (with very minor exceptions).
Slackware packages are considered as foreign packages, just like Ubuntu's, etc.
Slackware packages __may__ work in Fatdog but again, your mileages may vary.

> You can try asking the developers or someone on the forum to compile a package for you.

> There is a a [long thread→](http://oldforum.puppylinux.com/puppy/viewtopic.php?t=95287) of contributed Fatdog
packages in the old Puppy Forum, and a [Fatdog Software sub-forum→](https://forum.puppylinux.com/viewforum.php?f=140) in the new Puppy Forum.

> Finally, you could compile a package yourself.  This is how the 4000+ packages in the Fatdog repository are created.
Fatdog uses its own build system called _pkgbuild_ to create reproducible recipes for each package and compile them.
Pkgbuild can be found in `/usr/src/pkgbuild` when the DEVX SFS is loaded.

### Spot

Fatdog is a true multi-user system, so you can add different user accounts from the Fatdog64 Control Panel.
By default Fatdog starts as user `root`, exactly like Puppy.
User `spot` is the other default user account.  Spot is a "restricted" user, who can't change root's or the system's files.
By default Fatdog runs most network applications -- notably Internet browsers -- as user spot.
This provides some level of protection from malware but at a small cost.
Since spot can't change root's files,
a [browser running as spot](firefox-spot.md)
can't download directly into root's folder.

We recommend running network applications as user spot, but provide the flexibility to change
them to user root as explained in the above linked page.

To simplify dealing with up/downloads when the browser runs as spot, we use spot's home
folder as a sort of in/out basket.
Drag a file in/out of that folder from/to the browser poses no access restrictions.

To quickly open spot's home folder press the `Windows` key, keep it down, and press/release the `g` key.

### Touchpad

Some Puppies have the tapping for the touch pad enabled by default, Fatdog64 does not.

> Go to the Fatdog64 Control Panel Desktop tab and double-click _Adjust Touch Pad_ then enable the tap-to-click check box. [touchpad](touchpad.md)

20200909C

