%%textdomain fatdoghelp
![ ](fatdog64.png)
# Printing and printers

## Overview

Fatdog64 comes with CUPS printing system which is mostly standard nowadays.

Internally, the printing workflow looks as the following:

![CUPS printing workflow](cups-printing-workflow.png)

There are four components:

1. **Queue**: this is the (logical) place that holds the print job. CUPS will print whatever documents (print jobs) in here, unless they are being "suspended" (e.g. due to printer error).

2. **Filters**: these are programs that transform one data format to another, from the one that got submitted by frontends, to the one that can be understood by the backend. There can be many of these filters, and different documents may be processed by different filters, but the most important one is the last one, the one just before the backend.

3. **Backend**: this is the program that actually take the data from the filter and send it to the printer using various interfaces (USB, serial, parallel, network, bluetooth, etc).

4. **Frontends**: these are the programs and libraries that can put documents into the queue for printing. The frontend can be command line (e.g. lp, lpr), or GUI (e.g. gtklp), or included in programs capable of printing (e.g. libreoffice, evince PDF viewer, etc).

Each printer will have its own workflow, although the frontends are usually shared.

CUPS provides many of these components. Some of these components are generic and work for all printers, some are not. The device-dependent components are what is normally known as "printer drivers". In general, printer drivers consist of:

 * The final filter (the one that will pre-process the document before it gets sent to the backend), and
 * The backend itself.

CUPS comes with many drivers for common printers; and it also has generic drivers that can work for many printers. If you cannot get a vendor-specific driver to work, it is worthwhile to try these CUPS-provided generic drivers first.

------------------

## Generic drivers

CUPS provides 4 (four) kinds of generic drivers that can work with most printers. If your printers qualify with one of these, it is guaranteed that you can print, even though it may not be to your satisfaction (in terms of crispiness (a.k.a print density), colours matching, etc; but you can certainly print. So when shopping for a new printer, it is worthwhile to look for one of them.

1. **Postscript printers**. Originally developed by Adobe, Postscript is a generic type-setting language. It was (and is) commonly used on high-end printers due to high-resource requirements for its implementation. It used to be the lingua-franca for laser printers, and even today most high-end printers still come with Postscript support.

2. **PCL printers**. Originally developed HP, PCL was an alternative (competitor) to Postscript. It is simpler and requires less resources to implement, so today it is mostly found in mid-range printers, both laser printers and inkjets.

3. **PDF printers**. Originally developed by Adobe, PDF is descended from Postscript, and was optimised for printing. It was simpler and easier to implement, yet more versatile, incorporating years of experience that Adobe gained from Postscropt. Many modern high-end printers now support PDF as their printer language, allowing direct printing of PDF files.

4. **IPP Everywhere printers**. This is also known as the "__AirPrint__" printers, or "__driverless__" printers because they don't need any vendor-specific drivers (in reality, of course, it only means that the drivers are already included by CUPS). They are available on a lot more models including lower-end model because these are raster printers; most of the processing is done by the host (computer).

When you add a new printer in the CUPS web interface, and you were asked for the "make" (or model of the printer), you can choose "Generic" and from there choose the most appropriate generic drivers. Modern printers sometimes supports more than one: in this case, test printing with a few drivers and decide on which one delivers the best result.

**Note**: Postscript printers require Ghostscript to be installed. Ghostscript is available in Fatdog but is not installed by default, you need to install it from the repository.

------------------


## Model-specific drivers

Obviously not all printers can be supported by the generic drivers, and even those that do, may provide better performance (=better control of printing parameters e.g. dpi, duplexing control, etc). CUPS comes with a set of model-specific drivers. More model-specific drivers are available from __gutenprint__ package (which is installed by default), and from __foomatic__ and __foo2zjs__ packages (which are available in the repo).

They should be your next attempt if your printer does not support generic drivers or if the generic drivers perform poorly. Many brands are supported: HP, Epson, Canon, etc, generally if the printers have been on the market for several years, it may be supported. Furthermore, even if you cannot find the exact model of your printer, often a "close enough" model will make it print.

------------------



## Manufacturer-provided drivers

The last attempt would be to attempt manufacturer-provided drivers. This should be the last attempt if everything else fails; or if you need the most precise control from your printers.

Most manufacturer only provides the final "__filter__" as the drivers, although more complex printers requires both __filter__ and __backend__.

You can download these drivers from the manufacturer website, often after specifying your model. If the manufacturer provides a choice, here are the list of packaging that you should choose, in order of preference:

 * Slackware package
 * Generic tarball (often ends with .tar.gz extension)
 * Debian/Ubuntu packages (ends with .deb)
 * Anything else

If possible, find drivers for 64-bit Linux. If they only have 32-bit drivers, that's ok but remember you need to use 32-bit compatibility SFS each time you need to print.

Also, note that many manufacturer packages assumes that __Ghostscript__ is installed. So the first thing you do when you need to install 3rd party driver, is to install __Ghostscript__ from Fatdog repository.

The method to install the drivers vary, depending on how the packages are supported. It is way too diverse to explain here. It is best that you raise the issue on the forum and ask for people explain how to install the drivers; or even better, ask them to package a given driver into Fatdog-compatible packaging.

------------------



## Network printers

Setting up network printers is very similar to setting up a wired printer. The difficult part is to find the "device URI" in order to print it. In order to setup one, the network printer must have been connected into the network - this is very printer specific and this document simply assumes that you have done this (if not, please consult the user's manual for your printer).

There are two steps to configure network printer:

1. To find ("discover") the printer on the network.

2. To configure the "device URI" in order actually print to that printer using the network protocol that the printer supports.


### Printer discovery

Printer discover enables CUPS to find the printers in the network, and hopefully, configure it automatically (including the device URI). If your printer has full discovery support that Fatdog supports, then step (1) and (2) above is very easy and is done automatically. You just need to install the printer driver.

Most modern printers (especially branded as "AirPrint" capable) use ZeroConf or DNS-SD discovery protocol. Fatdog fully supports this and it will be able to find the printers and configure automatically. Some printers support more than one network protocol, so you may see multiple entries for the same printer. You can pick and choose, try and use the one that gives you the most consistent printing experience.

Older printers may support SNMP discovery. This is also supported by Fatdog CUPS, so you should be able to find the printer and the device URI should be pre-filled, but you may still need to edit it (replace a logical name with an IP address) to make it successfully print.

Others may only support LLMNR protocol (Microsoft clone of ZeroConf, not widely used outside Microsoft products); this isn't supported by Fatdog.

If Fatdog cannot find the printer, all is not lost. First thing, you need to know the IP address of the printer (it is best if the printer can be configured to use a fixed IP address in this case), and secondly, you need to know the network protocol supported by the printer, and finally the device URI.


### Device URI and Network Protocol

In order to be able to print to the network printer, CUPS needs to know where the printer is (its IP address) and what network protocol that it supports. If the printer supports DNS-SD, this is not an issue because DNS-SD can be used to translate a logical name to an IP address; but otherwise you really need to know the IP address. You can find this out from the printer itself, if you cannot, then, you need to perform some sort of "port scanning" to find it, unfortunately.

As for the network protocols, there are generally 3 (three) network printing protocols. CUPS supports all of them.

1. **HP JetDirect protocol**. Also known as the "socket" protocol, this was originally created by HP for its line of network printers. It is considered to be the simplest, fastest, and generally most reliable. Due to its simplicity it has been reverse-engineered and is now used by many other printers and print servers. Virtually every network printer will support this.

All that you need to know in order to print to a printer that uses this protocol is its IP address, and its printing port. Most printers uses 9100 as the port number as this was originally the port number used by HP printers.

2. **LPR/LPD protocol**. This is original network printing protocol. It is simpler and less featureful than JetDirect protocol; however it is also widely available.

In order to be able to print to this printer, you need to know 3 (three) things: its IP address, its printing port, and its queue name. The most commonly used printing port is 515. The queue name, unfortunately, differ from printer to printer and you really need to find out by reading its documentation (if the printer isn't discoverable).

3. **IPP protocol**. (IPP stands for Internet Printing Protocol). This is the newest and most feature-ful printing protocol. It is the "newest" but not exactly new, OS such as Windows XP from 2003 already support this protocol. If a printer supports it, this is the protocol to use.

In order to print to this printer, you need to know its URL (or device URI). The protocol is called either "ipp://" or "http://" (they're equivalent), and may or many not implement SSL. You also need to know the printer's IP address, port number, and its resource. The commonly used port number is 631; however for the resource name, you need to find it out from the printer documentation.

------------------

If you have a choice, IPP would be the best to use. Otherwise, you can use either JetDirect or LPR/LPD protocol with preference given to JetDirect. Once you know all the information needed, you can form the "device URI" when you add the printer to CUPS. The syntax of these URIs are given in CUPS "add printer" page.

------------------




## Sharing printers and using shared printers

Sharing CUPS printer and/or printing to a remote shared CUPS printer is very similar to printing to network printer as above. But firstly, before we can print to a shared printer, we must share the printer first.

### How to share a printer in CUPS for others to use

1. Firstly, you need to configure CUPS to enable sharing. This is commonly found in the CUPS Administration page.

2. Secondly, you need to enable individual printer for sharing. This is done on per-printer basis. First, go to "Manage Printers" page, find the printer that you want to share, then choose "Modify Printer" menu and share it.


### How to discover CUPS shared printer

1. In Fatdog, open Control Panel --> System --> Manage Server and Services.

2. Then find "cups-browsed" service. Then "Start" it. If you want to make a permanent sharing, sort of, you can click "Enable" too which will make the service automatically restarted at next boot.

That's all you need to do! If you now go to CUPS' "Printers" page, you should now be seeing printers that are shared from other CUPS servers. Note: for this automatically shared printers, if you turn off the "cups-browsed" service, they will disappear if you turn off ("stop") the service. If you want something which is more permanent, you need to configure it manually, as below.

### How to configure CUPS printer manually

Some CUPS does not properly advertise their shared printers. There are many reasons for this. You have shared the printer, but CUPS still cannot find it. In this case, we can set it up manually.

You may also setup a permanent sharing, because as noted above "cups-browsed" shared printers will automatically disappear when you turn off the service.

1. Visit the CUPS server that owns the printer. Check it's "Printers" page and get the "queue name" of the printer that you want to use. While you're at it, make sure that that printer is shared, and the CUPS has enabled for sharing. Oh, and take note of it's IP address too.

2. Then launch the CUPS webpage where you're going to use the shared printer. Go to "Administration" page, choose "IPP" protocol. You will be asked to present the "device URI". The device URI will look like this:

`ipp://ip-address:631/printers/queue-name`

where the `ip-address` is the IP address you get from (1), and the `queue-name` is the queue-name you get from (1) too.

When asked for the make/model, choose "Generic" and then choose "IPP Everywhere".

That's it!

------------------



## Other notes and loose ends

1. Some printers are "IPP Everywhere" printers but they only have USB interface (this is rare, I have yet to find one, but theoretically possible). You can use these printers by using "ippusbxd" package. Please read the document that comes with that package in order to set it up.

2. Some printers are multi function devices (MFP), which not only can print, but also can scan (and sometimes fax too). This page only covers the printing part of the device. The scanning part, unfortunately, is much less standardised and will most likely require proprietary drivers to make it work.
3. Printers advertised as "AirPrint" or being advertised as "mobile printers" (as in, you can use your mobile phone / smartphone to print to it directly) is most likely a "IPP Everywhere" / "driverless" printer.

4. Printing in Fatdog64 used to be supported by forum member rcrsn51, in Puppy Linux forum thread [here](http://oldforum.puppylinux.com/puppy/viewtopic.php?p=628636#628636). In May 2017, he has decided to retire his support. We sincerely thank him for all the help he has provided for many years prior. Although the main post of that thread is now gone, the thread may still contain useful information and helpful advices that can still be applied (suitably modified) on modern Fatdog, so it is still worth checking out when you have problems.

You can also still view an older copy of the thread, before its deletion, [here](https://web.archive.org/web/20150905152737/murga-linux.com/puppy/viewtopic.php?t=78464).

5. This document is meant for Fatdog 801 and newer. Older Fatdog may support some of the features, but for example "cups-browsed" did not exist so you will need to use the "manual method" to do it.


