%%textdomain fatdoghelp
![ ](fatdog64.png)
# Spot's home directory has moved (Fatdog64 720 onwards)

## Overview

Most network programs in Fatdog64 runs as the special user "spot".
"spot" is a root-surrogate, which means that it is doing things on
behalf of root, but at a reduced permission level. This is especially
useful for network programs: in case those programs have security
vulnerabilities, a remote attacker can only gain the privilege and
access level of the user "spot", instead of "root" (and let's hope the
machine doesn't have privilege-escalation kernel vulnerabilities that
enable an attacker to become "root" from "spot" ... but we digress).

To make the restriction of "spot" effective, user "spot" only has
access to a few places (otherwise, there is no point in using
"spot" at all). One of the few places that spot has access is, of course,
its home directory. In all earlier Fatdog64 versions, spot's home directory is
`/root/spot`. Why `/root/spot`? The reasons are buried in the mist of
history. Let's just say that Fatdog64 inherited `/root/spot` from its
very earliest days - it's a part of the Puppy Linux heritage that Fatdog64
still carries forward to today (well, before 720 was released).

This location of spot's home directory does indeed make it very awkward.

The primary thing that we want to protect is mainly the contents of /root, 
but /root/spot is inside /root, which means, in order to access /root/spot,
"spot" needs access to /root too, which negates the whole protection story we painted above. 

Or does it? 

As it turns out, no, not really. Unix permission has a way to allow 
spot to traverse /root to get access to /root/spot, without allowing it
to read anything else inside /root. This is because Unix has a separate
control to allow whether a user can read contents of a directory, 
or just traverse it. Previous versions of Fatdog allow spot to 
traverse /root to get to /root/spot, but disallow it to list or read 
any files in /root.

It works, but this is not perfect. The permission control of whether a 
file can be read (or not), is set on the file itself - not on the 
directory that contains the file. This means that although you cannot see 
the directory contents, you may still be able to read the files in it, 
provided that:

 * You know the name of the file
 * The permissions of the files allow it
 * You have the traverse permission to the containing directories

We need something better.

The only way to ensure that programs under user "spot" can never be able 
to read stuff in /root is to close the access of /root to spot, which 
means to revoke all access. But this means "spot" cannot access /root/spot 
anymore, and thus spot cannot have its home directory located here. 
It has to be moved elsewhere.

So spot's shiny new home directory is /home/spot.


----------------------------


## Effect of this change

You can no longer download stuff to /root/spot. The correct place is 
now /home/spot.

You can no longer upload stuff from /root directly, just by giving a 
permissive enough permission to the file, because now spot is not 
allowed to traverse /root at all.

You cannot view HTML files you keep in /root or its subfolders, because 
browsers (by default) run as spot, so they cannot read the files anymore.

In order to help you to ease the transitions, we have done the following:

 * The /root/Downloads symlink still exists and works, but now it points 
   to /home/spot/Downloads
 * /root/spot still exists, but it is now a symlink to /home/spot.
 * A new shortcut **(Win+G)** now opens Rox filer in spot's home
 * All programs that use spot's home directory have been updated to use 
   the new location.



### So what has not changed?

Spot still has access to the Downloads folder. When running as root 
(e.g. from ROX-Filer), dropping files to /root/spot will still drop 
them to spot's new home directory (thanks to the symlink), which spot has 
access to.

In the process, in order to upload stuff using the browser, the 
recommended way is to copy those files to the Downloads folder, and 
then upload from there, removing the files when the upload is completed. 
This still works.

Some people may do the same but using /root/spot for their temporary 
transit - this still works too.



### Note for existing Fatdog users

The changes above will apply for those who start with a fresh savefile on Fatdog64 720 or later.

How about those who migrated to Fatdog64 720 with an existing savefile 
from a previous Fatdog version? They still have content in /root/spot. 
Spot's home is still pointing to /root/spot. How can we ensure that they, too, 
enjoy the benefits of this better security?

While we _don't officially support_ carrying savefiles from older Fatdogs 
into a new one, we have provided a script which will help you. 
The script is called **/root/make-spot-more-secure**.

Launch this script (either from Terminal or from Rox), and it will guide 
you step-by-step to securing spot. It will create /home/spot with the 
proper structure, copy the files from /root/spot to /home/spot, and 
replace /root/spot with a symlink. 

You can do this yourself, but the script makes it easier. Please feel 
free to examine the script before running it if you feel uncomfortable.

The script is designed so that you can safely run it multiple times. 
It will detect that there is no further need for migration if it has been 
completed, and will do nothing in that case. Feel free to delete this 
script after you've completed the migration.



### Some other caveats and side-effects of the migration

1. "spot" is now its own user group. It is not part of the "users" group. 
The reason for this change is the same as above - spot should be 
restricted and un-related to any other users in the system. 
Thus, it is highly **NOT** recommended to run the desktop as "spot". 
If you want to run as a non-privileged user, instead of using spot, please 
make a new user (fido, etc.) and use that to run the desktop. (You can do 
this from Control Panel's User Manager or `mkuser.sh` from terminal).

**Note**: From Fatdog 800 onwards, if you enable "Move Downloads Folder" when saving the session, "spot" will be added back to the "users" group when the session is saved. This is because, if your savedevice is on a FAT partition, it can only be accessed by members of the "users" group. If "spot" isn't in the group then the "Downloads" folder will not be accessible. If you know that your savedevice is not FAT, then you can remove "spot" again from "users" for better security by running the command `busybox delgroup spot users`.

2. While the make-spot-more-secure program helps to relocate spot's home
to its new place, it does not (and cannot) help to migrate the myriad of
programs that may think that spot's home is still in the old location. 
This is not a problem for a fresh installation, but it may be a problem 
from an existing installation (as in, re-using the savefile from an older 
Fatdog). Two prominent programs comes to mind:

a) **The browser**. Older packages have been configured to download and print-to-PDF to /root/Downloads. This will **NOT** work anymore. You need
to explicitly set a new download folder (it's in /home/spot/Downloads), 
and also a new target folder for print-to-pdf (also /home/spot/Downloads). 
If you don't, everything will seem to succeed but you will find that your 
files are mysteriously missing (hint: they aren't: they just never get 
saved there in the first place because the browser cannot access /root/Downloads).

b) **Samba**.  It's public share folder, for older configurations, is still /root/spot. You will need to edit /etc/samba/smb.conf yourself and change it to /home/spot.



## But I don't want these hassles!

Of course, all this seems to be a lot of hassle. It does. If you really 
don't care about this, and have a strong belief that Linux is secure 
and impenetrable, or just prefer convenience, there are two things you 
can do:

a) Edit desktop files in **/usr/share/applications** and change their 
**Exec=** line. If you see anything with "**-spot**" in it, drop it 
(e.g. replace **firefox-spot** with **firefox**). This will make them run as user root and bypass all these "spot" issues.

b) If you can't even be bothered with that, you can always open the 
access to /root folder, using the command "**chmod permission-code /root**".

The older Fatdogs had their permissions code set to **711** (open access 
for "root", traverse access for all); in Fadog64 720 its permission 
is now **700** (open access for "root" only).

In order of more convenience (and less security), you can change its permissions to:

 * 711 (back to the older Fatdogs' way), or
 * **not-recommended:** 755 (open access for "root", traverse and list 
   contents access for all), or
 * **highly not recommended:** 777 (open access for all)

But before you do this, please know what you're doing.
We make all these changes for a reason; that reason is to put your 
security above everything else.
