%%textdomain fatdoghelp
![ ](fatdog64.png)
# How to suspend and hibernate

## Terminology

"suspend" aka "suspend-to-RAM" aka "STR" aka "sleep" --> store everything to RAM and stop CPU, harddisk, screen, etc. Machine still on, power still required although usage is small. Pressing (usually) the power button will wake up the CPU, which will restore its state from RAM, and continues. Fatdog64 has supported suspend since its early days.

"hibernate" aka "suspend-to-Disk" aka "STD" aka "hibernate" --> store everything to Disk, then power off. Pressing (usually) the power button will start-up the machine, run the bootloader, load and run kernel as usual, but the kernel will recognise that it is "waking up" from "hibernation" and will restore its state from Disk instead of the usual power-up. Support for hibernation starts with Fatdog64 721. On older Fatdogs you can also do hibernation if you update to the latest kernel.


## How to perform suspend

1. On terminal, type `echo mem > /sys/power/state`
2. Alternative, if you're on a laptop, just close the lid.

Where are these controlled?
`/etc/acpi/events/lid` is where lid-closing will trigger suspend script.
`/etc/acpi/actions/suspend.sh` is the actual suspend script, which will suspend the machine.

**Troubleshooting**: Suspend usually works. Most the problem is "failure to wake up" which can be fatal (e.g. screen fails to wake up: blank screen), or annoying (e.g. wifi fails to wake-up, requiring restart of network connection). Usually the problem is bad module. Identify that, and remove that module before suspend, and then reload (modprobe) that module again after waking up. See the suspend script above for examples. Or kill some process and re-start them again upon wake-up. If you still have problems, you're SOL: suspend is not for you.


## How to perform hibernation

Firstly, make sure suspend works. If you can't even make suspend to work then forget hibernation.
Secondly, you need to have a swap. Either swap partition or swap file will do. To be safe, make sure that swap partition/swap file is at least the size of your RAM.
Third, you need to prepare. Waking up from hibernation requires support the bootloader, so you must be comfortable of editing boot entries and adding boot parameter.
Fourth, make sure your disk that contains swap partition/swap file is a disk that can be accessed by the kernel without need for additional kernel modules or firmware. Don't attempt to do from LVM disks.

If you have a swap partition, take a note of your swap partition. For example assume it's **/dev/sda7**. Then in your boot loader entry, add a new parameter `resume=/dev/sda7` and you're good to go.
If you have a swap file, take a note of the partition that contains your swap file (e.g. **/dev/sda5**), and then run `filefrag -v /path/to/your/swapfile`. You will get an output something like below:

```
# filefrag -v /mnt/sda5/fd64-swap
Filesystem type is: ef53
File size of /mnt/sda5/fd64-swap is 8589934592 (2097152 blocks of 4096 bytes)
 ext:     logical_offset:        physical_offset: length:   expected: flags:
   0:        0..   32767:      36864..     69631:  32768:           
   1:    32768..   61439:      69632..     98303:  28672:           
   2:    61440..   94207:     100352..    133119:  32768:      98304:
```

Pay attention to the first row (row 0), and read the physical_offset. In this example, it's **36864**.
Then in your boot loader entry, add the following two parameters: `resume=/dev/sda5 resume_offset=36864`. Then re-boot. This reboot is required for swap file; for swap partition you don't need to reboot first. If you don't reboot, the hibernation will fail.

Once rebooted, on terminal you can do this: `echo disk > /sys/power/state`


## Additional Tips

1. Resuming from hibernation doesn't require loading the initrd; because everything (including the initrd) is already stored in the hibernation (swap) file. If you want faster "resume" from hibernation, instead of adding the above boot parameters to an existing boot entry that loads both the kernel and initrd, consider creating a new boot entry that only loads the kernel with the given parameter, e.g. (grub2 example: `linux /vmlinuz resume=/dev/sda5` resume_offset=36864). When resuming, choose this entry so your boot loader only loads the kernel (and not initrd). Of course, if your bootloader and disk is fast, you can ignore this.

2. If you use multiple swap files, on console type `cat /proc/swaps` and perform the `filefrag` command on the first swap file. Your first swap file must be at least the same size as the RAM.

3. If you don't like swap or don't usually use swap, but you want to hibernate, well then create a new swapfile and do all the above preparation. Before suspending, run the command in terminal `swapon /path/to/your/swapfile/or/device` and then hibernate. Upon wake-up, run this: `swapoff /path/to/swapfile/or/device` to turn off the swapfile usage.



## FAQS

**Q1**. I heard there is this feature called "hybrid suspend" where the state is copied to both RAM and Disk; and the the machine goes to suspend. If power is not lost during the suspend, it will wake up from RAM which is fast. But if power is lost, it will wake up from disk just like hibernation. This is good and cool because I can suspend to RAM and not worry about power lost.

**A1**. Not supported.

**Q2**. What about compressing the data used for hibernation?

**A2**. Not supported.

**Q3**. Hibernation is scary because kernel data is stored to disk, directly. Somebody could steal the disk and do a scan for password on the hibernation file. I heard you can encrypt the hibernation file?

**A3**. Not supported.

All the above features require an advanced suspend module (aka "userspace suspend") - which currently isn't implemented in Fatdog.
