%%textdomain fatdoghelp
![ ](fatdog64.png)
# Touchpad problems?

To change the behavior of the Synaptics / Alps touch pad, use
Control Panel - Desktop - Adjust Touch Pad. If Adjust Touch Pad errors
when you launch it, your touch pad is probably not supported yet;
see **synaptics** below.

By default, "tap-to-click" is disabled, as some touchpads are overly
sensitive, making the system impossible to use if it is left on.
To turn it back on:

 * Open **Adjust Touchpad** control from within Control Panel > Desktop tab.
 * Check the checkbox next to "Enable tap-to-click".
 * Then click apply.

**Vertical scrolling** is enabled by default, using the "two finger" method
(touch the touchpad with one finger, then use another finger to touch
and move on the touchpad). This of course requires a multi-touch touchpad; if you don't have one you need to use another method for scrolling.
To change it, open **Adjust Touchpad** as above, look at the dropdown
list for "Scroll Method", and choose another one which is suitable.
Don't forget to click apply.


---------------------------------------------------


If Control Panel - Desktop - Adjust Touch Pad doesn't offer the option
you want to adjust, you can do it manually by copying `50-touchpad-gui.conf`
to `/etc/X11/xorg.conf.d/60-touchpad-override.conf`.
Renaming it with numbers starting with "60" means that whatever setting
you specify here will override the settings you set with the
"Adjust Touchpad" settings, so beware.

Initially this file (after the copy) will contain the following settings:
```
#DO NOT EDIT! Used by touchpad settings app.
 Section "InputClass"
 Identifier "libinput"
 Driver "libinput"
 MatchDevicePath "/dev/input/event*"
     Option "AccelSpeed" "0.00"
     Option "DisableWhileTyping" "false"
     Option "HorizontalScrolling" "false"
     Option "LeftHanded" "false"
     Option "MiddleEmulation" "false"
     Option "NaturalScrolling" "false"
     Option "ScrollMethod" "twofinger"
     Option "Tapping" "false"
     Option "ClickMethod" "buttonareas"
EndSection
```

The first order of business is to change the identifier from "libinput"
to "libinput-override". You can remove the comment on the first line
too, since we're editing a copy (not the original file), so that warning
is not applicable.

Then you can change any other properties and settings. After editing,
save the file, and then you **must restart the X server** for any changes to take effect.

Here are a couple popular options to adjust :

 * **Option "Tapping" "false"**  This option sets the tap-to-click behavior.
   Setting this to "false" disables tap-to-click behaviour (which is the default).
   If you want tap-to-click, change this to "true" to start with and adjust as needed.  
 * **Option "AccelSpeed" "0.00"** This option sets how fast the mouse
   moves as you drag your finger across the pad. A smaller number is
   slower, a bigger number is faster. Ranges from -1 to 1.

If you need more configuration options, take a look at the man page for
[xf86-input-libinput](http://distro.ibiblio.org/fatdog/web/faqs/libinput.4.html).

**synaptics**

If libinput doesn't support your touchpad, you can try using the Gslapt package
manager to install **xf86-input-synaptics** and **flSynclient**, then restart X.
Synaptics is an older driver for touchpads and may not work properly
for newer devices; however if your hardware is old it may support it
better than libinput (or not - you just have to try).

It also has a lot more options. Use flSynclient to control its settings.
If you don't like it, you can always uninstall it and Xorg
will automatically revert to using libinput.

Synaptics can also be configured using a configuration file like above.
You can find the details for synaptics driver [here](http://distro.ibiblio.org/fatdog/web/faqs/synaptics.html).

