%%textdomain fatdoghelp
![Fatdog](fatdog64.png)
# Alternative Flash-drive Installation Method for UEFI Boot

This page explains methods and steps to make a bootable flashdrive suitable for booting on UEFI systems.

It assumes that you have booted into Fatdog and that you have a copy of the ISO file handy, or that you have followed a [simplified installation method](uefi-flashdrive.md) (in other words, you have a copy of the files from the Fatdog distribution).

Before beginning you must ensure that you have access to the Fatdog installation files. They are:
		efiboot.img
		vmlinuz
		initrd
		grub.cfg
		fatdog.png

You can find these files inside the Fatdog ISO distribution file; you can get access to these files by:
- Burning the ISO to a CD/DVD, after which you can access them by inserting it into your CD/DVD reader
- Opening the ISO file directly from inside Fatdog (click or double-click on it)
- dd-ing the ISO file to a flash drive using the [simplified installation method](uefi-flashdrive.md) and inserting the flash drive into your USB port.

## The steps

### Step 1

**Before mounting:**  Make sure your flash drive has a FAT32 partition, and it is large enough (512M or more) to hold copies of the Fatdog files. Some UEFI firmware also accepts FAT16 but the official standard requires FAT32. Most flash drives today ship with FAT32 factory-formatted so you usually don't even need to do this, but it is always good to check and confirm.

### Step 2

Name your partition as "FATDOG\_LIVE". Use dosfslabel from terminal or Gparted to do this.

### Step 3

Most UEFI firmware will accept any partition type if you use MBR partitioning. Some stricter ones don't, and in this case you need to set the partition type to type EF.

If you find that your flash drive is not listed, is ignored or is not recognised by the UEFI firmware boot menu, this may be the case; use fdisk from terminal to change the partition type as above.

Note: If you use GPT partitioning then the partition type must be set to EF00. Use gdisk to do this.

### Step 4

Do the steps above while your partition is *not* mounted. When done, mount your FAT32 partition (just click the drive icon from your desktop).

### Step 5

Copy vmlinuz, initrd, grub.cfg and fatdog.png from the Fatdog ISO/CD/DVD/flash drive to this FAT32 partition.

### Step 6

Open a terminal and cd to the path that contains the file efiboot.img. Then type "filemnt efiboot.img". A Rox window will appear. Do not close the terminal window.

### Step 7

Copy all the files from this window to your FAT32 partition.

### Step 8

Type "filemnt efiboot.img" once again in the same terminal that you used for step 6. The rox window should close.

---

That's it! Unmount your flash drive and you're ready to boot.

If you're feeling adventurous, you can go on and create additional partitions (e.g. ext4 or f2fs) on your flash drive into which you can put your savefile/savedir. You can also edit grub.cfg to meet your needs (e.g. adding boot parameters, removing unnecessary entries, etc).


## Yet another alternate method


If you feel that the above steps are too complicated, Puppy Linux forum member Ted Dog has prepared a ZIP file that contains pre-packaged boot files extracted from efiboot.img.

All you need to do is: download the ZIP file, extract the content of the ZIP file to your flash drive, and copy over the Fatdog64 ISO file there too. The complete steps and the links to the ZIP file can be found [here](http://oldforum.puppylinux.com/puppy/viewtopic.php?p=818727#818727). The same method can be re-used to boot other Puppy Linux variants too.

Forum member cat&dog has alternate instructions based on Ted Dog's method that work for him, [here](http://oldforum.puppylinux.com/puppy/viewtopic.php?p=865706#865706).

---


Note 1: If you follow these methods, you do not need to run fix-usb.sh; in fact doing so will ruin your flash drive partitioning, so don't do that.

Note 2: All the configuration files produced by this method are editable. Actually all the files are editable.

Note 3: Since this uses a standard partition table, Gparted should be able to modify it as usual.

