%%textdomain fatdoghelp
![ ](fatdog64.png)
# LICK Installer

## Overview

LICK is a Windows-based Puppy Linux installer, which fortunately
supports Fatdog too.

It installs (Puppy/Fatdog) Linux to an existing Windows machine,
non-destructively. After installation, you will be able to choose which
operating system you want to use: the original Windows, or the newly
installed Linux.
In other words, it creates a dual-boot installation, which is probably
what most of us are after.

It runs from within Windows, reads a Puppy or Fatdog ISO, copies the files,
and modifies the Windows bootloader appropriately. It supports
Windows 95, 98, ME, 2000, XP, Vista, 7, 8, 8.1 and 10, 32-bit or
64-bit - basically all version of Windows in the last 20-odd years or
so, up to the very latest one (as of this writing).

LICK supports installing to both BIOS and UEFI machines, both with or
without Secure Boot.

Before you use LICK, **please read this entire document**.
LICK installs to an existing Windows installation and make changes
to it, so it is important that you know what you're doing, and where
to find help if you get into trouble.


--------------------------------------------


## Installation with LICK

You can find LICK inside the Fatdog ISO; it will be in its own "lick"
subdirectory. The included copy is stored in compressed form to make
the size smaller. Run it first to install LICK, and from there you can
access LICK form the Administrator's menu.

LICK is easy to use. You just need to have a copy of the ISO image of
the (Puppy/Fatdog) Linux you want to install, and that's it.
All you need to do is:

 * Drag and drop the ISO image you want to use
 * Give an "id" for your to-be-installed Fatdog (don't include spaces)
 * Give a "name" for the your to-be-installed Fatdog (anything reasonable goes here)
 * Choose which drive to install to (C:, D:, etc)

And then click "Install". LICK will do the rest.


--------------------------------------------


## Notes

You may need to review the [boot options](boot-options-fd.md), and also [here](boot-options-savefile.md) to make sure they are correct for your installation.

LICK is home-grown project from long-time Puppy Linux user and
enthusiast, Lukas Lorimer (Puppy Linux forum name noryb009).
It is an open-source project with MIT license.

Click [here for LICK forum thread→](http://oldforum.puppylinux.com/puppy/viewtopic.php?t=61404)
on the Puppy Linux forum.
It is where new releases are announced, and it is also the appropriate
thread to ask questions and get help.
And this is its [github→ home](https://github.com/noryb009/lick),
to get both the source and the binaries.


--------------------------------------------


### LICK introduction on the forum thread says:

LICK is a Puppy Linux installer for Windows.
It configures Windows and Puppy Linux to create a dual-boot environment
in just a few clicks. This makes it perfect if you want to try out Linux
without the hassle of installing.

LICK is versatile: it can be run on almost any version of Windows,
from Windows 95 to Windows 10, on BIOS or UEFI.

LICK is easy to use: It does not require a CD to be burnt or a USB drive
to run. Download a Puppy Linux ISO and select it in the program to install it.

LICK is developer-friendly: If you want to bring the power of LICK to
your application or distribution, a command line utility and a library
are available. LICK is licensed under the MIT license, so feel free to
use it however you like.


--------------------------------------------


### LICK README on github says:

LICK is a free program to install Linux from Windows without burning a
CD or using a USB. It is as simple as installing and running LICK,
selecting a Linux ISO image, and clicking install.
A few seconds later, you can reboot into Linux.
Currently only Puppy Linux-based distributions are supported.

LICK runs on any Windows version, from Windows 95 to Windows 10.
Check below for any special notes on your Windows version type.

**Download**

You can download the latest version of LICK from Github.

**Windows Version Notes**

_Windows 8, 8.1 and 10_

Windows 8 and up have a feature called 'Fast Startup'.
This cannot be enabled if LICK is installed.
LICK disables Fast Startup upon installation.


_UEFI Systems with Secure Boot_

LICK supports secure boot, but requires a manual step during the first reboot.

 * On the first reboot, if you see a blue screen with writing, press enter to select OK.
 * Press enter again to select Enroll Hash.
 * Use the up and down arrow keys to highlight loader.efi, and press enter.
 * Press the down arrow to select Yes, then press enter.
 * Use the down arrow to highlight Exit, then press enter.

On subsequent reboots, these steps will not need to be taken.


_Windows ME_

By default, Windows ME does not have all dependencies LICK requires.
To fix this, install [Me2Dos](http://www.rkgage.net/bobby/download/Me2Dos.exe).
You can also read the [README](http://www.rkgage.net/bobby/download/readme.txt).
