%%textdomain fatdoghelp
![ ](fatdog64.png)
# Fatdog64 User Mode Linux (UML) Environment

## Introduction

According to the [User Mode Linux website](http://user-mode-linux.sourceforge.net/old/), User Mode Linux (UML for short) is:

_User-Mode Linux is a safe, secure way of running Linux versions and Linux processes. Run buggy software, experiment with new Linux kernels or distributions, and poke around in the internals of Linux, all without risking your main Linuxsetup._

_User-Mode Linux gives you a virtual machine that may have more hardware and software virtual resources than your actual, physical computer. Disk storage for the virtual machine is entirely contained inside a single file on your physical machine. You can assign your virtual machine only the hardware access you want it to have. With properly limited access, nothing you do on the virtual machine can change or damage your real computer, or its software._

---

UML is one of the earliest attempt at Linux virtualisation (the other one being ** lguest **, which is even lighter than UML but unfortunately only runs on 32-bit kernel). It has been largely superseded by more advanced technologies, Kernel-mode Virtual Machine (KVM) and Linux Containers (lxc), and is frequently considered to be of only academic interest these days; however it still has life left in it. For example it can be used to provide relatively easy and safe, secure sandboxing of untrusted applications.

Fatdog (since version 620) comes with the User Mode Linux (UML) environment. 

**All you need to do to use it is to install linux\_uml and uml\_utilities packages from the Package Manager.**

**Note for Fatdog64 700 and later users:** even if you are familiar with UML operation in the Fatdog64 600 series, please read on. The way UML is configured has changed.

## Usage

### Starting up

To start using UML, after installing the packages, all you need is to open a Terminal (there is no GUI for this), and type **start-uml.sh**. This will start a "throwaway" UML VM (or UML "guest") with 256MB of RAM. A window will open with the UML desktop in it.

### Shutting down

You can shutdown the UML VM by:

- Using the "shutdown" menu from within the UML desktop
- Running the command "poweroff" from the UML console
- If you have accidentally closed the terminal that runs the UML console, by running "killall vmlinux" from your host terminal.


It is "throwaway", because as soon as you stop the UML VM, all the information in it is gone - there will be no traces left. In this way, UML is very useful for testing purposes.

### Persistent UML

To run a persistent UML session (i.e., to be able to save the states between UML shutdown and restart), do the following:

**1.** Make an empty directory to contain the UML session. This directory must be large enough to contain the UML's "savefile".

**2.** Start UML like this: **start-uml.sh /path/to/session/directory**


Once UML has run for the first time in this way, it will create a "config" file in that session directory (which you can edit later).

A 128MB savefile is also automatically created for you; if you need anything bigger, just delete that savefile and edit the config to specify a larger value - the savefile will be re-created when you restart UML the next time.

See below for the details of the config file.

### Launching UML without graphical desktop

By default, UML will start with a graphical desktop. If you don't want the graphical desktop, start it like this:

        start-uml.sh "" pfix=nox  # for throwaway session
   
or
 
        start-uml.sh /path/to/session/directory pfix=nox

or edit the config file by putting *pfix=nox* into the **BOOT_OPTIONS** variable and then start UML the usual way.

The Xephyr window will still open (so that you can type "xwin" to launch a graphical desktop later).
If you don't need it, just close it after it opens.

## UML session config options

You can put a file named **config** in the session directory to configure UML's behaviour.
This file is automatically created (with default values) if it doesn't exist, or you can create it yourself before you start UML for the first time.

The file contains configuration variables, as follows.
Any of these settings can be "blanked" by not specifying the value, e.g. you can blank RAM _SIZE by putting **RAM SIZE=** inside the config file.

### RAM_SIZE default: 256M

Determines the size of the RAM allocated to the VM. By default start-uml.sh will assign 256 MB of RAM to the VM. This is a reasonable size for most graphical applications.

If you don't run any GUI or other memory intensive applications, you can lower this number.

UML itself will happily start with 32MB of RAM (although you probably can't do much with it).
Note: the letter 'M' is required, it specifies "megabytes".

### SAVEFILE\_SIZE default: 128 and SAVEFILE\_FS default: ext2

SAVEFILE\_SIZE determines the size (in megabytes) of the savefile to be created if it doesn't exist.
SAVEFILE\_FS determines the filesystem used when the savefile is created (you can specify ext2, ext3 or ext4).

If you leave SAVEFILE\_SIZE blank, no savefile will be created if it doesn't exist.
These variables are ignored if you already have an existing savefile.
Note: Do not append 'M' for SAVEFILE\_SIZE, just specify the numbers.

### SAVEFILE\_PATH default: /savefile.ext2

The location of the savefile, ** *relative* ** to the location of the session directory. Set to blank if you don't want to use a savefile at all (e.g, run a "throwaway" session).

Unlike the real Fatdog, if you run without a savefile, you will not be prompted to create a savefile at the end of the UML session - the session is simply gone after you shut it down.

### HOST\_IP default: blank and HOST\_ADAPTER default: blank and UML\_IP default: blank

These settings control the IP address assignments on the host and the UML "guest".

All of these can be left blank, and start-uml.sh will provide reasonable values for them. You can set them manually if you require some special configuration or if the automatic values do not work.

**Some notes about IP addresses**
 
UML\_IP sets the address that will be assigned inside the UML "guest" itself. Unless you want to use *masquerading*, this address must be on the same subnet as the physical network that the host is attached to.

HOST\_IP sets the address that will be used as the "gateway" on the host. It is not really used, but must be assigned, and it has to be on the same subnet as the UML\_IP (thus, it has to be on the same subnet as the physical network as well, unless you want to use *masquerading*).

HOST\_ADAPTER is only used if HOST\_IP is blank.

If HOST\_IP is blank, it will be set to the IP address of HOST\_ADAPTER. If HOST\_ADAPTER is blank, then the first active network adapter with an IP address (other than the loopback interface) will be used.

If UML\_IP is blank, it will be set to the HOST\_IP but with the last component increased by 100 (mod 255). E.g. If your HOST\_IP is 10.0.0.5 then UML\_IP will be 10.0.0.105; if your HOST\_IP is 10.0.0.250 then your UML\_IP will be 10.0.0.95 (that is, (250+100) mod 255).

If you leave this parameter blank, it will be set to 100 + IP address from the  HOST\_ADAPTER will be used. If HOST\_ADAPTER is blank, then the first non-local IP address will be used. E.g. if you have both eth0 (IP: 10.0.0.50) and wlan0 (192.168.1.5) and both variables are set to blank, the HOST\_IP will be set to 10.0.0.150 and the UML\_IP will be set to 10.0.0.149.

**Note:** UML supports sophisticated routing; if you wish you can create network bridges with iptables masqueraded etc but these are complex things beyond the purpose of start-uml.sh. If you need to do this you probably want to write your own UML script wrapper, using start-uml.sh as a baseline.

### NAME_SERVER default: 8.8.8.8

The DNS server which will be used by UML VM (this is the value that gets set inside /etc/resolv.conf) to resolve host names.
By default the value is 8.8.8.8, which is Google's DNS server.


### START_CMD default: blank

Specifies the command to be automatically executed when UML starts.

You can set this to run your own programs directly inside UML; it will be executed in the "root" login context as the last stage of rc.sysinit.

### WINDOW_SIZE default: 1024x700

Sets the window size of the graphical desktop of the virtual X server (Xephyr).

If you leave it blank, no virtual X server will be started and you will not be able to launch graphical applications.

### NICE_CMD default: blank

Specifies the **nice** command for use when running the UML kernel.

It is used to lower the process priority used by the UML kernel; if you're running as root it can be used to make UML run faster too, by giving it more priority.

### BOOT_OPTIONS default: blank

Specifies additional boot options that you want to pass to the UML Linux kernel.

For example if you want to load additional SFS or additional disk images, you need to pass the **ubd**xxx**** parameters; specify them here.

For the full set of available boot options, run **/usr/lib64/uml/vmlinux** from the terminal. If you have a custom startup script, you can also pass parameters here which can be read by your startup script by inspecting /proc/cmdline.

---

Note: A few of the variables you define in the config file can be overridden by putting other values into the command line when you start UML, for example when starting UML without graphical desktop as above.

## Questions and Answers

### Question

Why UML, why not KVM or even VirtualBox?

### Answer

UML is much smaller, use fewer resources, makes use of your existing Fatdog installation (no need for separate ISO files), and is easier to set up. 

You can run UML with only 32MB of RAM (for text-mode applications) - you can't do that with KVM or VirtualBox.

### Question

Fatdog already has [sandbox](sandbox.md); so what is this UML for?

### Answer

Fatdog's sandbox isn't meant for security. It was originally devised for testing foreign packages, so while it can be used for other purposes, there are information leakages to and from the sandbox; and this is intentional:  otherwise you'll face problems when testing.

For example, sandbox and the host share the same "/tmp" directory.

Fatdog's UML, however, doesn't suffer from such a problem - host and UML guest are completely separate.
E.g. If you choose "shutdown" from sandbox's desktop, you will shutdown your entire system (not only the sandbox).

Not so with UML.
Choosing "shutdown" from UML's desktop will just shutdown the UML VM.

### Question

What can the UML VM do?

### Answer

Almost everything the host system can do. Browse the internet, run network applications (servers), etc.
but probably not enough to watch videos, as there is no video acceleration in UML.

### Question

I understand that the UML is isolated, but is there a way to pass data to and from the UML? Otherwise how can I ever do anything worthwhile with UML?

### Answer

Of course there is. The point is, this data sharing is completely under your control.

- You can set up a "savefile", which can be opened while the VM is offline; from there you can copy data to or from it.

- You can copy data using the network (e.g. using samba rox app / yassm, netcat, ssh, rsync, etc).

- You can create additional disk images which can be mounted both by the host and by the UML (using the **ubdxxx** parameter - see below).

You can open these disk images from the host when they are not mounted from the UML VM; and when done you can mount them and access the data from inside the VM.

### Question

UML only loads Fatdog's base SFS. Is there a way to load additional SFS files too?

### Answer

Yes. Specify additional SFS fiels like this (assuming you want to use a throwaway session):

	start-uml.sh "" ubd1rc=/path/to/your/sfs ubd2rc=/path/to/your/sfs

where **udb1rc** will show up as **/dev/udbb** inside the UML VM, **udb2rc** will show up as **/dev/udbc**, and so on.

Then to load these SFS files, once you're inside the UML VM, open a terminal and type:

		load_sfs.sh /dev/udbb
		load_sfs.sh /dev/udbc

and so on.
If you're using persistence then replace "" with /path/to/your/session/directory.

### Question

Does running UML require root access?

### Answer

No. You can run UML even if you're not root. Inside UML, however, you are root ☺ 

### Question

How do I quit the UML properly?

### Answer

Choose "Shutdown" from the desktop menu if you run UML with the desktop (default). If you start UML without the desktop, terminate UML by running **poweroff** from the console window.

- **Do not close** the Xephyr window unless you have no plan to run graphical applications.

- Closing the Xephyr window *does not* stop the UML session (it will terminate all the graphical applications, but not the UML itself).

- **Do not close** the terminal window you used to start UML.

  Closing this terminal *does not* stop the UML itself.

  If you accidentally close the terminal, run **killall vmlinux** on your host to stop the UML.

### Question

OK, now that I can use console only stuff, I need more consoles. How do I get that?

### Answer

Run this inside the UML VM: **setsid getty 38400 tty1** 

An xterm window will be opened that represents your new  "console".
Replace **tty1** with **tty2**, **tty3**, etc., as many as you need.

*Warning:* Once the xterm windows are opened, **do not close** them; closing them will cause UML to hang. These xterms will automatically be closed when you stop your UML session.

### Question

UML is slow!

### Answer

Unlike other virtualisation solutions, UML does not create demand on the CPU - it will simply use whatever idle power has been given.

The default CPU frequency scaling governor in Fatdog is "ondemand", which means that the CPU power will be controlled by "demand" - if the CPU power is not needed then the frequency of the CPU will be lowered to save power (and lower the temperature too).

If it detects that there is a "demand" or need for it, it will then increase the frequency to make the CPU more powerful so that it can do its job faster.

UML does not create this demand (even though in reality it is running slowly), so the "ondemand" governor does not think it necessary to make the CPU go faster.

To fix this, temporarily change the default CPU frequency scaling governor from the default  "ondemand" to "performance" (which means run the CPU at full power at all times) while running UML. There is a commented script on how to do so in /etc/rc.d/rc.local.

Alternatively, you can use NICE_CMD configuration options (or run *renice* if you have already started the UML session) so that the UML kernel will get more priority. This can only be done when you run UML as root.

---

## Further information

- UML's web page here: [user-mode-linux.sourceforge.net/old/](http://user-mode-linux.sourceforge.net/old/) 

- See what kernel options are available by opening terminal and running this (on the host):
   
        /usr/lib64/uml/vmlinux --help

- Look at start-uml.sh and uml-init scripts' source code in **/usr/lib64/uml**.

