%%textdomain fatdoghelp
![ ](fatdog64.png)
# urxvt (rxvt-unicode) tips and tricks

## Introduction

urxvt (aka rxvt-unicode) is is a fork of the well known terminal emulator rxvt, with unicode support. It aims to be small (smaller than xterm in terms of memory usage), fast, and complete.

This document records some known issues with urxvt and (in the future) other tips and tricks.

## Known issues

### Some fonts do not show properly (characters are shown as boxes)

There are many reasons why this happens. The most common reason is that you are trying to show Unicode characters which aren't supported by the font-set that you're using. This usually can be corrected by using the correct font-set and correct fallback fonts.

There is one known specific issue with some (Powerline) fonts. By default, Fatdog64 uses urxvt's settings of `URxvt*letterSpace: -1` to reduce the inter-letter spacing of the default monospace font (DejaVu Sans Mono), so it displays nice and tight, not wasting screen width. However, the correction may be too tight for some special fonts, such as powerline fonts, causing urxvt to display boxes. Try changing -1 to 0 or even 1 to help urxvt display the special characters correctly. This will make the terminal window wider.

Note: This setting is defined in `/etc/X11/app-defaults/URxvt` (which you can override by creating an entry in file in `~/.Xdefaults` or `~/.Xresources`).

## Tips and Tricks

### urxvt with perl extensions (clickable url links, tabs ...etc.)

Optional - Set your default browser:

Open Fatdog Control Panel-> Desktop-> Fatdog64 Edit Default Programs and ensure that BROWSER is set to the choice of browser you prefer.

Open Fatdog Control Panel-> System-> Gslapt Package Manager, type rxvt in the search box and press <Enter>.  Locate the `rxvt-unicode_perl_true_color` package, right click the selection box and select Install, and then click the Execute button to install that package.

It is a much larger version of urxvt than the Fatdog default urxvt version as it is compiled to use perl extensions.  Those perl extensions, however, open up additional useful functionality such as tabs, text search, clickable links... and more.

Click Menu-> Restart X to restart X, and now when you run urxvt (terminal) shift down-arrow will open a new tab. Shift left- (or right-) arrow to step between tabs. Shift up-arrow to rename the current tab (<Enter> when you are done). Control left- or right- arrow to re-arrange tab order.

Tab font size can be increased and decreased with Control up- and down- arrow respectively. Note that changing font size will also resize the window, so it is best to change font size when the window is maximized.

Control Alt `r` will enter scrollback incremental search mode, and display an input field at the bottom of the window. Start typing a search term to highlight visible matches. Shift up- and down-arrow will move through the matches. Escape will exit search mode.

Any links will be underlined and you can middle mouse click links to open that link (url) in your default web browser (as defined above).  If you'd rather have links open using a different mouse button, edit /root/.Xresources and change the URxvt.matcher.button: 2 setting to : 1 for left mouse click, 2 for middle mouse click, 3 for right mouse click. Restart X after making such edits in order for the changes to become effective.
