%%textdomain fatdoghelp
![ ](fatdog64.png)
# Bootable USB Installation

## Foreword

This is an alternative installation to install Fatdog64 to a USB flash drive. It will work for both BIOS and (U)EFI machines.

The installation process will **destroy** the existing content of the flash drive, so either do this on a new USB flash drive or use one that you don't mind erasing.

The installation process requires the use of "**dd**" command (equivalent on Windows is Win32DiskImager or similar). If you are not familiar with "dd" command, then stop now because the wrong usage of "dd" **can cause data loss of your system**. (There is a reason why "dd" is sometimes called as "**disk destroyer**").

This installation will work from Fatdog64 811 onwards. It requires some files which is only distributed in Fatdog64 ISO from version 811 onwards. It would also work on older Fatdogs if you get the necessary files from newer Fatdogs.

---



## Installation

The installation files required for this method can be found in the "**usb-boot**" folder on the Fatdog ISO.

There are two files: README, and boot-images.tar.xz. It is the latter which is important.

**boot-image.tar.xz** contains two files, called

 - **usb-boot-mbr.img** (for USB flash drive less than 2TB in size, using MBR partition), and
 - **usb-boot-gpt.img** (for any size, not limited to 2TB, uses GPT partition).

Each one of them expands to about 530MB when extracted. They work identically so this guide will explain how to use the MBR variant. To use the GPT variant, read the supplied README.

First, extract the **usb-boot-mbr.img**.

Then, use "dd" or Win32DiskImager or similar tools, and write it to your USB flash drive. In Linux this can be done as

```
dd if=usb-boot-mbr.img of=/dev/sdd bs=4k
```

Assuming that your USB flash drive is at /dev/sdd.

Note: Choosing the wrong target can destroy your harddisk and causes data loss, if you are not sure where the USB flash drive is located, then **STOP NOW AND DO NOT CONTINUE WITH THIS PROCESS**.

Note that you need to write to the USB disk itself, not its partition, i.e. you need to write to /dev/sdd and not to /dev/sdd1, for example.

Once the "dd" is done, you will end up with two partitions on the USB flash drive. Ignore the first partition (16 MB FAT partition labelled "ESP"), and only look at the second partition (labelled "OS").

The second partition will have the size of 512MB and is formatted as ext4. There are already files stored in this partition, but they are examples only to get your started.

To boot Fatdog, you just need to copy the following files from Fatdog ISO:

 - vmlinuz
 - initrd
 - initrd-nano (optional, only if you have slow BIOS, usually if you run ancient motherboard)

And that's it.

---


## FAQ


**Q**: But 512MB is too small!
**A**: Sure. Grab the files, resize the partition using gparted or your other favourite partition tool and copy the files back.

**Q**: I don't like ext4.
**A**: Sure. Grab the files, re-format the partition with the filesystem that you like, and copy the files back.

**Q**: There are only two partitions?
**A**: Yes. Feel free to create the 3rd, 4th and other partitions as you wish.

**Q**: Can I edit the example files? For example, can I edit grub.cfg to add other entries?
**A**: Definitely. Keep a copy in case you mess up, though.

**Q**: Can I boot other Puppies with this too? Multiple puppies?
**A**: Sure, if you know the command line parameters that you need to pass, and if you know how to edit grub.cfg to do that.

**Q**: There are multiple configuration files! I see menu.lst on the "ESP" partition. Which one I should edit?
**A**: You only need to edit grub.cfg on the "OS" partition. Do not touch anything else. The primary boot loader is grub2.

**Q**: Can I put OS files in other partition other than "OS"? E.g. Can I create a 3rd partition and put multiple versions of Fatdogs there?
**A**: Yes you can, but it's better that you re-size "OS" to make it fit to contain all the OS you want to put. Leave the 3rd partition for your data.


