%%textdomain fatdoghelp
![ ](fatdog64.png)
# NetBIOS Name Resolution

If you work often with Samba shares, you know that Samba hostnames (also known as the NetBIOS names) cannot be accessed with the usual tools like **ping**, **mount**, etc (will end up with unknown host error) while specialised Samba tools like **smbclient** apparently can find these servers.

This is because specialised Samba tools uses libraries enabling them to map these NetBIOS names to IP address, and then use the IP address internally. The usual network tools uses DNS for name resolution, and NetBIOS names uses a different mechanism, so it doesn't work.

However, the hostname resolver in glibc is extensible and it is possible to add NetBIOS name resolution mechanism into it, so the from network tools point of view, it looks very similar.

This is done by installing special libraries, a server software (**winbindd** - which is part of Samba), and editing **/etc/nsswitch.conf**. This special libraries etc are packaged in a package called **samba4-winbindd**. Install this package, and then start the **winbindd** service (you can start manually or configure it to start every time at boot), and magically all your Samba hostnames can be ping-ed, and mounting will not require you to specify IP address, etc.

**Note**: **samba4-winbindd** package works with **samba4-cutdown**. If you install the FULL **samba4** package, these libraries and server are already included; you don't need to install it again. All you need to do is edit **/etc/nsswitch.conf** and append "**wins**" to the end of the line that starts with "**hosts:**"
