#!/bin/sh

# Errors shouldn't cause script to exit.
set +e

# Update mime database.
update-mime-database /usr/share/mime 2>/dev/null

# Add ROX-Filer mime handler
# Prefer mime package file over .desktop MimeTypes=, which could claim other types.
awk -F= -v TARGET="/usr/bin/keepassxc" '
# (an input pipe from xml2 would be more accurate, but)
$1 ~ "<mime-type[ \t]+type" {
  type = $2 # "application/x-keepass2">
  gsub(/["> \t]/, "", type)
  sub("/", "_", type)
  print "ln -sf "TARGET" /etc/xdg/rox.sourceforge.net/MIME-types/"type | "sh"
}
' /usr/share/mime/packages/keepassxc.xml

# Mime sync for Fatdog64. (currently disregards /usr/local/...)
[ -x /usr/bin/fatdog-sync-mime.sh ] && /usr/bin/fatdog-sync-mime.sh

# Refresh icon cache.
gtk-update-icon-cache -q -t -f /usr/share/icons/hicolor

true

