#!/bin/sh

# Errors shouldn't cause script to exit.
set +e

# Update mime database.
update-mime-database /usr/share/mime

# Delete ROX-Filer mime handler
for i in /etc/xdg/rox.sourceforge.net/MIME-types/*; do
  [ "$(readlink "$i")" = /usr/bin/keepassxc ] && rm -v "$i"
done

# Mime sync for Fatdog64. (currently disregards /usr/local/...)
[ -x /usr/bin/fatdog-sync-mime.sh ] && /usr/bin/fatdog-sync-mime.sh

# Update icons in the hicolor icon theme.
gtk-update-icon-cache -q -t -f /usr/share/icons/hicolor

true

