#!/bin/sh

###############################################################################
# PackIt v1.20 by SFR'2013-2016,2019                                          #
# GNU GPL v2 applies                                                          #
# Thanks to Pemasu for helping me with making this script Woof-friendly       #
###############################################################################

# -----------------------------------------------------------------------------
# Associate ROX 'SendTo/OpenWith' with PackIt
# -----------------------------------------------------------------------------

PackIt_PATH="/usr/local/apps/PackIt"

LOC1="/etc/xdg/rox.sourceforge.net/SendTo"
LOC2="$HOME/.config/rox.sourceforge.net/SendTo"
LOC3="$HOME/.config/rox.sourceforge.net/OpenWith"
LOC4="/root/.config/rox.sourceforge.net/OpenWith"

if [ "$(pwd)" = "/" ]; then
	for i in "$LOC1" "$LOC2" "$LOC3" "$LOC4"; do
		[ -d "$i" ] && { RC_PATH="$i"; break; }
	done
	Globs_PATH="/usr/share/mime/globs"
	Types_PATH="/usr/share/mime/types"
else	# Woof/Fatdog build system
	for i in ".$LOC1" ".$LOC2" ".$LOC3" ".$LOC4"; do
		[ -d "$i" ] && { RC_PATH="$i"; break; }
	done
	Globs_PATH="./usr/share/mime/globs"
	Types_PATH="./usr/share/mime/types"
fi

if [ -d "$RC_PATH" ]; then

	# Creates missing folders using contents of 'globs' file
	for i in $(grep ":" "$Globs_PATH" | cut -f1 -d ':' | tr '/' '_' | uniq); do
		[ ! -d "${RC_PATH}/.${i}" ] && mkdir "${RC_PATH}/.${i}"
	done
  
	# Creates missing folders using contents of 'types' file
	for i in $(cat "$Types_PATH" | tr '/' '_' | uniq); do
		[ ! -d "${RC_PATH}/.${i}" ] && mkdir "${RC_PATH}/.${i}" 
	done
  
	[ ! -d "${RC_PATH}/.inode_unknown" ] && mkdir "${RC_PATH}/.inode_unknown"
	[ ! -d "${RC_PATH}/.group" ] && mkdir "${RC_PATH}/.group"
  
	# Creates symlink to PackIt in every folder
	for i in $(find "$(realpath "${RC_PATH}")" -maxdepth 1 -type d -iname ".*"); do
		[ ! -L "${i}/PackIt" ] && ln -s "$PackIt_PATH" "${i}/PackIt"
	done
	[ ! -L "${RC_PATH}/PackIt" ] && ln -s "$PackIt_PATH" "${RC_PATH}/PackIt"
  
fi

# -----------------------------------------------------------------------------

# Associate custom action with Thunar
if [ "$(pwd)" = "/" ]; then
	if [ $(which thunar 2>/dev/null) ] || [ $(which Thunar 2>/dev/null) ]; then
		CONFIG="$HOME/.config/Thunar/uca.xml"
		CONFIG_BAK="$HOME/.config/Thunar/uca.xml.bak"
		CONFIG_TMP="/tmp/uca.xml"
		if [ -f "$CONFIG" ]; then
			grep '<name>PackIt</name>' "$CONFIG" >/dev/null || {
			grep -v '^</actions>' "$CONFIG" > "$CONFIG_TMP"
			echo '<action>
	<icon>PackIt</icon>
	<name>PackIt</name>
	<command>/usr/local/apps/PackIt/AppRun %F</command>
	<description>Archive files</description>
	<patterns>*</patterns>
	<directories/>
	<audio-files/>
	<image-files/>
	<other-files/>
	<text-files/>
	<video-files/>
</action>
</actions>' >> "$CONFIG_TMP"
			mv "$CONFIG" "$CONFIG_BAK"
			mv "$CONFIG_TMP" "$CONFIG"
			}
		else
			mkdir -p "${CONFIG%/*}"
			echo '<?xml encoding="UTF-8" version="1.0"?>
<actions>
<action>
	<icon></icon>
	<name>PackIt</name>
	<command>/usr/local/apps/PackIt/AppRun %F</command>
	<description>Archive files</description>
	<patterns>*</patterns>
	<directories/>
	<audio-files/>
	<image-files/>
	<other-files/>
	<text-files/>
	<video-files/>
</action>
</actions>' > "$CONFIG"
		fi
	fi
fi

# -----------------------------------------------------------------------------

# Create shortcut on pinboard/desktop
[ "$(pwd)" = "/" ] && /usr/local/apps/PackIt/createshortcut &

# =============================================================================
