#!/bin/dash
# quick-locale-switcher.sh, replacement for rox AppRun
# display an icon on icon tray showing actual language
# left-click: launch quick-locale-switcher
# right-click: launch quick-locale-switcher --help
# (C) L18L 2015
# License: GPL Version 3 or later
#
# uses 'sit' (simple-icon-tray) from technosaurus
# icon by courtesy of http://www.languageicon.org/
# version 1.5 Oct-20,2015

export TEXTDOMAIN=fatdog

all_LANGUAGE_names=/usr/share/i18n/lang_names
allLOCALES=/usr/share/i18n/locales
LOCALES_ICON=/usr/share/pixmaps/midi-icons/language48.png
LOCALES_TOOLTIP=/tmp/locale-switcher.$$
#LOCALES_LEFT_CLICK=fatdog-quick-locale-switcher
LOCALES_LEFT_CLICK="`which quick-locale-switcher`"
LOCALES_LEFT_CLICK="`which fatdog-quick-locale-switcher`"
LOCALES_RIGHT_CLICK="$LOCALES_LEFT_CLICK -h"

[ -f $all_LANGUAGE_names ] && L="`grep -m 1 "^${LANG%_*}" $all_LANGUAGE_names`" #ex: nl:Nederlands
[ "$L" ] || { L="`grep -m1 '^language' ${allLOCALES}/${LANG%.*}`"; L="${L#*\"}"; L="${L%\"*}"; } #ex: Upper Sorbian
[ "$L" ] || L="${LANG%_*}" # fallback to language code

> $LOCALES_TOOLTIP
[ "`locale -a | grep -i utf | grep -v ^en_`" ] && echo -n "
 $(gettext 'Change
 language
 from')
_______________
" > $LOCALES_TOOLTIP
echo -n "
 ${L#*:} 
 " >> $LOCALES_TOOLTIP	#ex: 'Nederlands' OR 'Upper Sorbian' OR 'a code' but always includes: 'English'
 
# right click gives info about adding a locale

# launch sit and set trap handler
sit $LOCALES_ICON $LOCALES_TOOLTIP "$LOCALES_LEFT_CLICK" "$LOCALES_RIGHT_CLICK" &
XPID=$!
trap 'kill $XPID; rm -rf $LOCALES_TOOLTIP; exit' INT TERM HUP # kill sit when we die
