"use strict";

Components.utils.import("resource://gre/modules/Services.jsm");

var tfull = {};

function startup(data,reason) {
  forEachOpenWindow(loadIntoWindow);
  Services.wm.addListener(WindowListener);

  // Prefs
  let branch = Services.prefs.getBranch("");

  branch.setBoolPref("extensions.truefullscreen.old-full-screen-api", branch.getBoolPref("full-screen-api.enabled"));
  branch.setBoolPref("full-screen-api.enabled", true);
}

function shutdown(data,reason) {
  if (reason == APP_SHUTDOWN) {
    return;
  }

  let branch = Services.prefs.getBranch("");
  branch.setBoolPref("full-screen-api.enabled", branch.getBoolPref("extensions.truefullscreen.old-full-screen-api"));
  branch.clearUserPref("extensions.truefullscreen.old-full-screen-api");

  forEachOpenWindow(unloadFromWindow);
  Services.wm.removeListener(WindowListener);

  Services.obs.notifyObservers(null, "chrome-flush-caches", null);
}

function install(data,reason) {}

function uninstall(data,reason) {}

function loadIntoWindow(window) {
  window.addEventListener("fullscreen", fullScreenListener, true);
  
  var menubar = window.document.getElementById('toolbar-menubar');
  
  menubar.addEventListener('DOMMenuBarActive', menubarActivated, true);
  menubar.addEventListener('DOMMenuBarInactive', menubarDeactivated, true);
}

function fullScreenListener(e) {
  var window = this;

  var toolbox = window.document.getElementById('navigator-toolbox');

  if (!toolbox) {  // probably not necessary
    return;
  }

  var appcontentElem = window.document.getElementById('appcontent');
  var contentElem = window.document.getElementById('content');


  var pref = Services.prefs.getBranch("");

  var isFS = toolbox.getAttribute('inFullscreen') == 'true';

  tfull.tabsAutoHide = true;

  try {
    tfull.tabsAutoHide = pref.getBoolPref("browser.tabs.autoHide");
  } catch (e) {}

  toggleToolbars(!isFS, window);

  if (!window.chromeStateBeforeFS) {
    window.chromeStateBeforeFS = {};
  }

  var findbar = window.document.getElementById("FindToolbar");

  if (isFS) {
    // going into full screen
    window.addEventListener('mousemove', mouseMove, true);

    // we grab border widths because Modern Theme has 1px borders on top and bottom
    // - we remove them on full screen
    tfull.borderTopWidth = window.getComputedStyle(appcontentElem).getPropertyValue("border-top-width");
    tfull.borderBottomWidth = window.getComputedStyle(contentElem).getPropertyValue("border-bottom-width");
    appcontentElem.style.borderTopWidth = '0';
    contentElem.style.borderBottomWidth = '0';

    // hide sidebar
    window.chromeStateBeforeFS.sidebarState = window.SidebarGetState();
    window.SidebarSetState("hidden");

    // hide findbar
    if (findbar) {
      window.chromeStateBeforeFS.findbarHidden = findbar.hidden;
      window.findbarWasOpenedInFS = false;
      findbar.close();

      findbar.addEventListener("findbaropen", userOpensFindbarInFS, true);
    }

  } else {
    // back from full screen
    window.removeEventListener('mousemove', mouseMove, true);

    appcontentElem.style.borderTopWidth = tfull.borderTopWidth;
    contentElem.style.borderBottomWidth = tfull.borderBottomWidth;

    // we don't restore collapsed state because of some bugs in SM causing
    // the grippy to not respond to clicks
    if (window.chromeStateBeforeFS.sidebarState && window.chromeStateBeforeFS.sidebarState != "collapsed" && window.SidebarGetState() == "hidden") {
      // SidebarSetState() is buggy after user opens and closes sidebar in full screen so we use SidebarShowHide()
      if (window.chromeStateBeforeFS.sidebarState == 'visible') {
        window.SidebarShowHide();
      }
    }

    // restore findbar
    if (findbar) {
      // we don't restore findbar if user opened and closed it in FS manually
      var findbarWasClosedInFS = window.findbarWasOpenedInFS && findbar.hidden;

      if ('findbarHidden' in window.chromeStateBeforeFS
          && !window.chromeStateBeforeFS.findbarHidden
          && !findbarWasClosedInFS) {
        findbar.open();
      }

      findbar.removeEventListener("findbaropen", userOpensFindbarInFS, true);
    }
  }
}

function toggleToolbars(show, window) {
  var toolbox = window.document.getElementById('navigator-toolbox');
  var tabStrip = window.document.getAnonymousElementByAttribute(window.document.getElementById('content'), 'anonid', 'strip');
  var notifyBox = window.gBrowser.getNotificationBox();

  if (show) {
    // show
    toolbox.removeAttribute('collapsed');

    if (window.document.getElementById("content").tabs.length > 1 || !tfull.tabsAutoHide) {
      tabStrip.removeAttribute('collapsed');
    }
    notifyBox.notificationsHidden = false;

  } else {
    // hide
    toolbox.setAttribute('collapsed', 'true');
    tabStrip.setAttribute('collapsed', 'true');
    notifyBox.notificationsHidden = true;
  }
}

// when mouse is at the top in fs then show tab strip
function mouseMove(e) {
  var window = e.currentTarget;

  if (e.screenY == 0) {
    toggleToolbars(true, window);

  } else if (window.document.getElementById('navigator-toolbox').getAttribute('collapsed') != 'true'
        && !(e.target.ownerDocument instanceof window.XULDocument)
        && window.document.getElementById('toolbar-menubar').getAttribute('inactive') == 'true'
        && !tfull.preventHideOnMousemove) {
    toggleToolbars(false, window);
  }
}

function userOpensFindbarInFS(e) {
  var window = e.currentTarget.ownerDocument.defaultView;
  window.findbarWasOpenedInFS = true;
}

function menubarActivated(e) {
  var window = e.currentTarget.ownerDocument.defaultView;
  if (window.fullScreen) {
    if (tfull.hideTimeout) {
      window.clearTimeout(tfull.hideTimeout);
      tfull.hideTimeout = null;
    }
    toggleToolbars(true, window);
  }
}

function menubarDeactivated(e) {
  var window = e.currentTarget.ownerDocument.defaultView;
  
  if (window.fullScreen) {
    // we hide toolbars after a delay to avoid toolbars flickering on windows
    // when menubar is activated with alt/F10 and then clicked on with mouse
    tfull.hideTimeout = window.setTimeout(function() {
      tfull.hideTimeout = null;
      toggleToolbars(false, window);
    }, 30);
  }
}


function unloadFromWindow(window) {
  window.removeEventListener("fullscreen", fullScreenListener, true);
  window.removeEventListener('mousemove', mouseMove, true);
  
  var menubar = window.document.getElementById('toolbar-menubar');
  menubar.removeEventListener('DOMMenuBarActive', menubarActivated, true);
  menubar.removeEventListener('DOMMenuBarInactive', menubarDeactivated, true);

  var findbar = window.document.getElementById("FindToolbar");
  if (findbar) {
    findbar.removeEventListener("findbaropen", userOpensFindbarInFS, true);
  }

  delete window.chromeStateBeforeFS;
  delete window.findbarWasOpenedInFS;
}

// Apply a function to all open browser windows
function forEachOpenWindow(todo) {
  var windows = Services.wm.getEnumerator("navigator:browser");
  while (windows.hasMoreElements()) {
    todo(windows.getNext().QueryInterface(Components.interfaces.nsIDOMWindow));
  }
}


var WindowListener = {

  onOpenWindow: function(xulWindow) {
    var window = xulWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                          .getInterface(Components.interfaces.nsIDOMWindow);

    function onWindowLoad() {
      window.removeEventListener("load",onWindowLoad);
      if (window.document.documentElement.getAttribute("windowtype") == "navigator:browser") {
        // we use timeout because the full screen state of windows is not
        // up to date when invoked by the fullscreen listener - can't really
        // explain why is that
        window.setTimeout(function() {
          loadIntoWindow(window);
        }, 0);
      }
    }
    window.addEventListener("load",onWindowLoad);
  },

  onCloseWindow: function(xulWindow) { },
  onWindowTitleChange: function(xulWindow, newTitle) { }
};
