#include <QApplication>
#include <QSystemTrayIcon>
#include <unistd.h>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    	
	int timeout = -1; // in seconds, -1 means wait forever
    if (argc > 1) {
		timeout = atoi(argv[1]);
	}

	if (timeout < 0) {
		// wait forever
		while (!QSystemTrayIcon::isSystemTrayAvailable()) {
			sleep(1);
		}

	} else {
		// wait with timeout
		printf("Will time out after %d seconds\n", timeout);
		while (!QSystemTrayIcon::isSystemTrayAvailable()) {
			if (timeout-- <= 0 ) break;
			sleep(1);			
		}
	}
	
	// exit code
	if (QSystemTrayIcon::isSystemTrayAvailable()) return 0;
	else return 1;
}
