/*
 * Logitech Bus Mouse Driver for Linux
 *
 * Trimmed down for testing kmouse
 */

#define __KERNEL__
#define MODULE

#include <linux/module.h>

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/busmouse.h>
#include <linux/signal.h>
#include <linux/errno.h>
#include <linux/mm.h>
#include <linux/mouse.h>
#include <linux/random.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/major.h>

#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/irq.h>

#define MY_SILLY_MINOR 32

static struct mouse_status mouse;

static kdev_t dev = MKDEV(MOUSE_MAJOR,MY_SILLY_MINOR);

/*
 * These two can be called by kmouse, with inode and file both NULL
 */
 void close_mouse(struct inode * inode, struct file * file)
{
  MOD_DEC_USE_COUNT;
  mouse.active--;
  printk(KERN_DEBUG "fakemouse close: count is %li\n",mod_use_count_);
}

 int open_mouse(struct inode * inode, struct file * file)
{
    MOD_INC_USE_COUNT;
    if (mouse.active) return -EBUSY;
    mouse.active++;
    printk(KERN_DEBUG "fakemouse opened by %s: count is %li\n",
           current->comm,mod_use_count_);
    return 0;
}

/*
 * writes are used to fake a kmouse stealing
 */

 int write_mouse(struct inode *inode, struct file *file,
                       const char *buf, int count)
{
    int read=0;
    char luf[3]; /* local buf */

    if (!mouse_stealing)
        return -ENODEV;

    while(count>=3) {
        memcpy_fromfs(luf,buf,3);
        mouse_stealing->steal_packet(dev,luf[0]&7,luf[1]&0xf,luf[2]&0xf);
        buf+=3;
        count-=3;
        read+=3;
    }
    printk(KERN_DEBUG "fakemouse: dropping %i bytes\n",count);
    return read+count;
}

/*
 * read mouse data.  Currently never blocks.
 */

 int read_mouse(struct inode * inode, struct file * file, char * buffer, int count)
{
    return -EINVAL;
}

struct file_operations bus_mouse_fops = {
    NULL,	/* mouse_seek */
    read_mouse,
    write_mouse,
    NULL, 	/* mouse_readdir */
    NULL,       /* mouse_select */
    NULL, 	/* mouse_ioctl */
    NULL,	/* mouse_mmap */
    open_mouse,
    close_mouse,
};

struct mouse bus_mouse = {
    MY_SILLY_MINOR, "fakemouse", &bus_mouse_fops
};

int bus_mouse_init(void)
{

    mouse.present = 1;
    mouse.active = 0;
    mouse.ready = 0;
    mouse.buttons = 0x87;
    mouse.dx = 0;
    mouse.dy = 0;
    mouse.wait = NULL;
    printk("fake bus mouse installed\n");
    mouse_register(&bus_mouse);
    return 0;
}

#ifdef MODULE

int init_module(void)
{
    return bus_mouse_init();
}

void cleanup_module(void)
{
    mouse_deregister(&bus_mouse);
}
#endif



