/*
 * kmouse.h -- common information to kmouse and gpm configuring it
 *
 * Copyright (C) 1996 Alessandro Rubini (rubini@ipvvis.unipv.it)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#define KMOUSE_VERSION   "0.20"
#define KMOUSE_VERSION_N    20   /* decimal: MMMmmm */

#define KMOUSE_V_MAJOR(n) ((n)/1000)
#define KMOUSE_V_MINOR(n) ((n)%1000)

#ifdef __KERNEL__

#undef PDEBUG
#undef PDEBUGG
#undef CP
#undef Static

#ifdef DEBUG_KMOUSE
#  define PDEBUG(fmt,args...) printk (KERN_DEBUG "kmouse: " fmt , ## args)
#  define Static
#  define CP(n) /* checkpoint */ \
          ({int i; PDEBUG("%s: %i\n",__FILE__, __LINE__); \
	      for (i=0;i<n;i++) schedule();})
#else
#  define PDEBUG(fmt,args...)
#  define Static static
#  define CP(n)
#endif
#define PDEBUGG(fmt,args...)


typedef struct kmouse_protocol {
	short protoid;
	short howmany;
	unsigned char proto[4];
	int (*fun)(Gpm_Event *state, unsigned char *data);
	short busmouse;
} kmouse_protocol;

#endif /* __KERNEL__ */


enum kmouse_proto {
	PROTO_UNKNOWN = 0,
	PROTO_BARE    = 1,
	PROTO_MSC     = 2,
    PROTO_SUN     = 3, 
	PROTO_PS2     = 4,
    PROTO_MS      = 5,     /* with three button extension */
    PROTO_LOGI    = 6,
    PROTO_MM      = 6,      /* the same as logi */
	PROTO_MMAN    = 7,
    PROTO_NCR     = 8
};

struct kmouse_options {
    dev_t dev;
    char sequence[8];
    unsigned short protoid, three;
    unsigned short delta, accel;
    unsigned short scale, scaley;
    unsigned short time, tap;
    unsigned short ptrdrag;
};
    
#define KMOUSE_GETVER 0x6bc0  /* ioctl magic is 'k' */
#define KMOUSE_SETOPT 0x6bc1

