/******************************************************************************
 JBroadcaster.h

	Interface for JBroadcaster class.

	Copyright  1994 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JBroadcaster
#define _H_JBroadcaster

#include <JRTTIBase.h>

class JBroadcasterList;

class JBroadcaster
{
public:

	class Message : public JRTTIBase
		{
		public:

			virtual	~Message();

		protected:

			Message(const JCharacter* type)
				:
				JRTTIBase(type)
			{ };
		};

public:

	JBroadcaster();
	JBroadcaster(const JBroadcaster& source);

	virtual	~JBroadcaster();

	const JBroadcaster& operator=(const JBroadcaster& source);

	JBoolean	HasSenders() const;
	JSize		GetSenderCount() const;
	JBoolean	HasRecipients() const;
	JSize		GetRecipientCount() const;

protected:

	void	ListenTo(const JBroadcaster* aSender);
	void	StopListening(const JBroadcaster* aSender);

	void			Broadcast(const Message& message);
	virtual void	Receive(JBroadcaster* sender, const Message& message);

	void			BroadcastWithFeedback(Message* message);
	virtual void	ReceiveWithFeedback(JBroadcaster* sender, Message* message);

	virtual void	ReceiveGoingAway(JBroadcaster* sender);

private:

	JBroadcasterList*	itsSenders;			// the objects to which we listen
	JBroadcasterList*	itsRecipients;		// the objects that listen to us

private:

	void	AddRecipient(JBroadcaster* aRecipient);
	void	RemoveRecipient(JBroadcaster* aRecipient);

	void	AddSender(JBroadcaster* aSender);
	void	RemoveSender(JBroadcaster* aSender);
};

#endif
