/******************************************************************************
 JInPipeStream.cc

	This class provides a blocking istream interface to the read end
	of a pipe.  If you need non-blocking input, avoid iostream since it
	doesn't understand non-blocking anything and put a protocol layer on
	top of ACE instead.

	BASE CLASS = istream

	Copyright  1998 by John Lindal. All rights reserved.

 *****************************************************************************/

#include <JInPipeStream.h>
#include <jStreamUtil.h>
#include <unistd.h>
#include <jErrno.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 *****************************************************************************/

JInPipeStream::JInPipeStream
	(
	const int		fd,
	const JBoolean	close
	)
	:
	ios(&itsBuffer),
	istream(&itsBuffer),
	itsBuffer(fdopen(fd, "r")),
	itsDescriptor(fd),
	itsCloseFlag(close)
{
}

/******************************************************************************
 Destructor

 *****************************************************************************/

JInPipeStream::~JInPipeStream()
{
	close();
}

/******************************************************************************
 close

	This only closes the underlying file descriptor if itsCloseFlag is set.

 *****************************************************************************/

void
JInPipeStream::close()
{
	if (!bad())
		{
		if (itsCloseFlag && ::close(itsDescriptor) != 0)
			{
			cerr << "JInPipeStream failed to close pipe: " << jerrno() << endl;
			}

		JSetState(*this, badbit);
		}
}
