/******************************************************************************
 jDirUtil.h

	Utility functions for dealing with directories.

	Copyright  1996 by Glenn W. Bach. All rights reserved.

 ******************************************************************************/

#ifndef _H_jDirUtil
#define _H_jDirUtil

#include <JStdError.h>
#include <time.h>

#ifdef __MWERKS__
	#include <stat.h>
#elif defined __VCPP__
	#include <sys/stat.h>
#else
	#include <sys/stat.h>
	#include <sys/types.h>
#endif

class JString;
class JProgressDisplay;

JBoolean	JNameUsed(const JCharacter* name);
JBoolean	JSameDirEntry(const JCharacter* name1, const JCharacter* name2);
JError		JGetModificationTime(const JCharacter* name, time_t* modTime);
JError		JGetPermissions(const JCharacter* name, mode_t* perms);
JError		JSetPermissions(const JCharacter* name, const mode_t perms);
JString		JGetPermissionsString(const mode_t mode);

JBoolean	JDirectoryExists(const JCharacter* dirName);
JBoolean	JDirectoryReadable(const JCharacter* dirName);
JBoolean	JDirectoryWritable(const JCharacter* dirName);
JBoolean	JCanEnterDirectory(const JCharacter* dirName);

JError		JCreateDirectory(const JCharacter* dirName);
JError		JCreateDirectory(const JCharacter* dirName, const int mode);
JError		JRenameDirectory(const JCharacter* oldName, const JCharacter* newName);
JError		JChangeDirectory(const JCharacter* dirName);
JError		JRemoveDirectory(const JCharacter* dirName);
JBoolean	JKillDirectory(const JCharacter* dirName);

JString		JGetCurrentDirectory();
JBoolean	JGetHomeDirectory(JString* homeDir);
JBoolean	JGetHomeDirectory(const JCharacter* user, JString* homeDir);
JBoolean	JGetTrueName(const JCharacter* name, JString* trueName);
JBoolean	JSearchSubdirs(const JCharacter* startPath, const JCharacter* name,
						   const JBoolean isFile, const JBoolean caseSensitive,
						   JString* path, JString* newName = NULL,
						   JProgressDisplay* pg = NULL);

JString		JGetUniqueDirEntryName(const JCharacter* path, const JCharacter* namePrefix);
JString		JGetTempDirectoryName(const JCharacter* path = NULL);

JString		JCombinePathAndName(const JCharacter* path, const JCharacter* name);
JBoolean	JSplitPathAndName(const JCharacter* fullName, JString* path, JString* name);
void		JAppendDirSeparator(JString* dirName);
void		JStripTrailingDirSeparator(JString* dirName);
void		JCleanPath(JString* path);
JBoolean	JIsRootDirectory(const JCharacter* dirName);

JBoolean	JConvertToAbsolutePath(const JCharacter* path, const JCharacter* base,
								   JString* result);
JString		JConvertToRelativePath(const JCharacter* path, const JCharacter* base);

JBoolean	JExpandHomeDirShortcut(const JCharacter* path, JString* result,
								   JString* homeDir = NULL, JSize* homeLength = NULL);
JString		JGetClosestDirectory(const JCharacter* origDirName,
								 const JBoolean requireWrite = kFalse);

#endif
