/******************************************************************************
 tesptrtmap.cc

	Test code for the JStringPtrMap class and related code.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#include <iostream.h>

#include <JStringPtrMap.h>
#include <JStringPtrMapCursor.h>
#include <string.h>

#include <jAssert.h>

	void PrintError(long line);

	const JSize gNumStrings = 16;

/******************************************************************************
 main

 *****************************************************************************/

int
main()
{
	JSize i;

	cout << "Beginning JStringPtrMap test.  No news is good news." << endl;

	const JCharacter* keyConst = "testkey";
	JCharacter* const key = new JCharacter[strlen(keyConst)+1];
	strcpy(key, keyConst);

// Mostly just test PtrMap specific things like DeleteAll

	{
		JStringPtrMap<JCharacter> ptrMap; // Ridiculous table size to really exercise resizer

	// Insert keys
		for (i=0;i<gNumStrings;i++)
			{
			key[0] = 'A' + i;
			JCharacter* newValue = new JCharacter[strlen(key)+1];
			strcpy(newValue, key);
			if ( !ptrMap.SetNewElement(key, newValue) )
				{
				PrintError(__LINE__);
				}
			}
		if (ptrMap.GetElementCount() != gNumStrings)
			{
			PrintError(__LINE__);
			cout << "   Map contains wrong number of elements!" << endl;
			}
		if (ptrMap.GetLoadCount() != gNumStrings)
			{
			PrintError(__LINE__);
			cout << "   Map contains extra deleted elements!" << endl;
			}

		{
// Compare with cursor
		JSize count = 0;
		JStringPtrMapCursor<JCharacter> cursor(&ptrMap);
		while ( cursor.Next() )
			{
			const JCharacter* thisKey = cursor.GetKey();
			JCharacter* cursorValue = cursor.GetValue();
			if (strcmp(thisKey, cursorValue) != 0)
				{
				PrintError(__LINE__);
				cout << "   Cursor found value " << cursorValue << ", should have been "
				     << thisKey << "!" << endl;
				}
			JCharacter* mapValue;
			JBoolean found = ptrMap.GetElement(thisKey, &mapValue);
			if (!found)
				{
				PrintError(__LINE__);
				cout << "   Cursor and map find inconsistent keys!" << endl;
				}
			if (strcmp(cursorValue, mapValue) != 0)
				{
				PrintError(__LINE__);
				cout << "   Map found value " << mapValue
				     << " inconsistent with cursor value "
				     << cursorValue << "!" << endl;
				}
			++count;
			}
		if (count != gNumStrings)
			{
			PrintError(__LINE__);
			cout << "   Cursor counted wrong number of elements!" << endl;
			}
		}
	}

	delete[] key;

	cout << "Finished JStringPtrMap test.  If nothing printed out, it passed." << endl;

//	JMemoryManager::Instance()->SetPrintExitStats(kTrue);

	return 0;
}

/******************************************************************************
 PrintError

 *****************************************************************************/

void
PrintError
	(
	long line
	)
{
	cout << "*** testptrmap error at line " << line << endl;
}