/******************************************************************************
 JXCSFSelectPrevDirTask.h

	Interface for the JXCSFSelectPrevDirTask class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXCSFSelectPrevDirTask
#define _H_JXCSFSelectPrevDirTask

#include <JXUrgentTask.h>

class JString;
class JUNIXDirInfo;
class JXUNIXDirTable;

class JXCSFSelectPrevDirTask : public JXUrgentTask
{
public:

	JXCSFSelectPrevDirTask(JUNIXDirInfo* dirInfo, JXUNIXDirTable* dirTable,
						   const JCharacter* dirName);

	virtual ~JXCSFSelectPrevDirTask();

	virtual void	Perform();

private:

	JUNIXDirInfo*	itsDirInfo;		// we don't own this
	JXUNIXDirTable*	itsDirTable;	// we don't own this
	JString*		itsDirName;

private:

	// not allowed

	JXCSFSelectPrevDirTask(const JXCSFSelectPrevDirTask& source);
	const JXCSFSelectPrevDirTask& operator=(const JXCSFSelectPrevDirTask& source);
};

#endif
