/******************************************************************************
 JXChooseSaveFile.h

	Interface for the JXChooseSaveFile class.

	Copyright  1996-98 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXChooseSaveFile
#define _H_JXChooseSaveFile

#include <JChooseSaveFile.h>

class JUNIXDirInfo;
class JXDirector;
class JXCSFDialogBase;
class JXChooseFileDialog;
class JXChoosePathDialog;
class JXSaveFileDialog;

class JXChooseSaveFile : public JChooseSaveFile, virtual public JBroadcaster
{
public:

	JXChooseSaveFile();

	virtual ~JXChooseSaveFile();

	virtual JBoolean ChooseFile(const JCharacter* prompt,
								const JCharacter* instructions,		// can be NULL
								JString* fullName);
	virtual JBoolean ChooseFile(const JCharacter* prompt,
								const JCharacter* instructions,		// can be NULL
								const JCharacter* origName,
								JString* fullName);
	virtual JBoolean ChooseFiles(const JCharacter* prompt,
								 const JCharacter* instructions,	// can be NULL
								 JPtrArray<JString>* fullNameList);

	virtual JBoolean ChooseRPath(const JCharacter* prompt,
								 const JCharacter* instructions,	// can be NULL
								 const JCharacter* origPath,		// can be NULL
								 JString* newPath);
	virtual JBoolean ChooseRWPath(const JCharacter* prompt,
								  const JCharacter* instructions,	// can be NULL
								  const JCharacter* origPath,		// can be NULL
								  JString* newPath);

	virtual JBoolean SaveFile(const JCharacter* prompt,
							  const JCharacter* instructions,		// can be NULL
							  const JCharacter* originalName,
							  JString* newFullName);

	void	ReadSetup(istream& input);
	void	WriteSetup(ostream& output) const;

protected:

	virtual JXChooseFileDialog*
	CreateChooseFileDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
						   const JCharacter* fileFilter, const JCharacter* origName,
						   const JBoolean allowSelectMultiple,
						   const JCharacter* message);

	virtual void	SetChooseFileContentFilter(JUNIXDirInfo* dirInfo);

	virtual JXChoosePathDialog*
	CreateChoosePathDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
						   const JCharacter* fileFilter,
						   const JBoolean selectOnlyWritable, const JCharacter* message);

	virtual JXSaveFileDialog*
	CreateSaveFileDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
						 const JCharacter* fileFilter, const JCharacter* origName,
						 const JCharacter* prompt, const JCharacter* message);

	JUNIXDirInfo*	GetDirInfo();

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	JUNIXDirInfo*	itsDirInfo;			// NULL if not global JXCSF stored in jXGlobals
	JString*		itsUserFilter;
	JString*		itsDialogState;		// empty if not global JXCSF stored in jXGlobals

	JXChooseFileDialog*	itsChooseFileDialog;
	JXChoosePathDialog*	itsChoosePathDialog;
	JXSaveFileDialog*	itsSaveFileDialog;
	JXCSFDialogBase*	itsCurrentDialog;

	JBoolean			itsResponse;
	JString*			itsResultStr;	// not owned; non-NULL if any other dialog is open
	JPtrArray<JString>*	itsResultList;	// not owned; non-NULL if choose multiple file dialog is open

private:

	JBoolean	ChooseFile(const JCharacter* prompt,
						   const JCharacter* instructions,		// can be NULL
						   const JCharacter* origName,			// can be NULL
						   const JBoolean allowSelectMultiple);

	JBoolean	ChoosePath(const JBoolean selectOnlyWritable,
						   const JCharacter* instructions,
						   const JCharacter* origPath,
						   JString* newPath);

	void	WaitForResponse(JXCSFDialogBase* dlog);

	void	RestoreState(JXCSFDialogBase* dlog) const;
	void	SaveState(JXCSFDialogBase* dlog);

	JString*	GetDialogState() const;

	// not allowed

	JXChooseSaveFile(const JXChooseSaveFile& source);
	const JXChooseSaveFile& operator=(const JXChooseSaveFile& source);
};

#endif
