/******************************************************************************
 JXHelpDirector.h

	Interface for the JXHelpDirector class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXHelpDirector
#define _H_JXHelpDirector

#include <JXWindowDirector.h>
#include <JXHelpManager.h>		// need definition of Format
#include <JXMenu.h>				// need definition of JXMenu::Style

class JXTextButton;
class JXTextMenu;
class JXHelpText;
class JXPSPrinter;

class JXHelpDirector : public JXWindowDirector
{
public:

	JXHelpDirector(const JCharacter* title, const JCharacter* text,
				   const JXMenu::Style menuStyle, JXPSPrinter* printer);

	virtual ~JXHelpDirector();

	void	ShowSubsection(const JCharacter* name);

protected:

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	JXTextMenu*	itsFileMenu;
	JXHelpText*	itsText;

// begin JXLayout

    JXTextButton* itsCloseButton;
    JXTextButton* itsTOCButton;

// end JXLayout

private:

	void	BuildWindow(const JCharacter* title, const JCharacter* text,
						const JXMenu::Style menuStyle, JXPSPrinter* printer);

	void	UpdateFileMenu();
	void	HandleFileMenu(const JIndex index);

	// not allowed

	JXHelpDirector(const JXHelpDirector& source);
	const JXHelpDirector& operator=(const JXHelpDirector& source);
};

#endif
