/******************************************************************************
 JXMessageDialog.cc

	BASE CLASS = JXUNDialogBase

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXMessageDialog.h>
#include <JXUserNotificationIcons.h>
#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXStaticText.h>
#include <JXImageWidget.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXMessageDialog::JXMessageDialog
	(
	JXDirector*			supervisor,
	const JCharacter*	message
	)
	:
	JXUNDialogBase(supervisor)
{
	BuildWindow(message);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXMessageDialog::~JXMessageDialog()
{
}

/******************************************************************************
 BuildWindow (private)

 ******************************************************************************/

void
JXMessageDialog::BuildWindow
	(
	const JCharacter* message
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 330,110, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* okButton =
        new JXTextButton("Dismiss", window,
                    JXWidget::kFixedLeft, JXWidget::kFixedBottom, 139,79, 62,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXStaticText* text =
        new JXStaticText("", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 60,20, 250,50);
    assert( text != NULL );

    JXImageWidget* icon =
        new JXImageWidget(window,
                    JXWidget::kFixedLeft, JXWidget::kFixedTop, 20,20, 40,40);
    assert( icon != NULL );

// end JXLayout

	window->SetTitle("Message");
	SetButtons(okButton, NULL);

	Init(window, text, message, icon, JXGetMessageIcon());
}
