/******************************************************************************
 JXNewDisplayDialog.cc

	BASE CLASS = JXDialogDirector

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXNewDisplayDialog.h>
#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXInputField.h>
#include <JXStaticText.h>
#include <jXGlobals.h>
#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXNewDisplayDialog::JXNewDisplayDialog
	(
	JXWindowDirector* supervisor
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow();
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXNewDisplayDialog::~JXNewDisplayDialog()
{
}

/******************************************************************************
 BuildWindow (protected)

 ******************************************************************************/

void
JXNewDisplayDialog::BuildWindow()
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 310,110, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 199,79, 62,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 60,80, 60,20);
    assert( cancelButton != NULL );

    itsDisplayName =
        new JXInputField(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,40, 270,20);
    assert( itsDisplayName != NULL );

    JXStaticText* obj1 =
        new JXStaticText("Name of display:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,20, 110,20);
    assert( obj1 != NULL );

// end JXLayout

	window->SetTitle("Open new display");
	SetButtons(okButton, cancelButton);

	itsDisplayName->SetIsRequired();
}

/******************************************************************************
 OKToDeactivate (virtual protected)

 ******************************************************************************/

JBoolean
JXNewDisplayDialog::OKToDeactivate()
{
	if (!JXDialogDirector::OKToDeactivate())
		{
		return kFalse;
		}
	else if (Cancelled())
		{
		return kTrue;
		}

	const JString displayName = itsDisplayName->GetText();
	JIndex displayIndex;
	if ((JXGetApplication())->OpenDisplay(displayName, &displayIndex))
		{
		itsDisplayIndex = displayIndex;
		return kTrue;
		}
	else
		{
		return kFalse;
		}
}
