/******************************************************************************
 TestButtonsDialog.cc

	BASE CLASS = JXDialogDirector

	Written by John Lindal.

 ******************************************************************************/

#include "TestButtonsDialog.h"
#include "SmileyBitmaps.h"
#include <JXWindow.h>
#include <JXStaticText.h>
#include <JXColormap.h>

#include <JXTextButton.h>
#include <JXImageButton.h>

#include <JXTextCheckbox.h>
#include <JXImageCheckbox.h>

#include <JXRadioGroup.h>
#include <JXTextRadioButton.h>
#include <JXImageRadioButton.h>
#include <jXGlobals.h>
#include <jAssert.h>

static unsigned char okButtonData[] =
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x10, 0x03, 0x80, 0xc1,
   0x40, 0x08, 0x03, 0x60, 0x00, 0x43, 0x08, 0x03, 0x20, 0x00, 0x42, 0x04,
   0x03, 0x10, 0x00, 0x44, 0x02, 0x03, 0x10, 0x00, 0x44, 0x01, 0x03, 0x08,
   0x00, 0x48, 0x01, 0x03, 0x08, 0x00, 0xc8, 0x00, 0x03, 0x08, 0x00, 0x48,
   0x00, 0x03, 0x08, 0x00, 0xc8, 0x00, 0x03, 0x08, 0x00, 0x48, 0x01, 0x03,
   0x10, 0x00, 0x44, 0x01, 0x03, 0x10, 0x00, 0x44, 0x02, 0x03, 0x20, 0x00,
   0x42, 0x04, 0x00, 0x60, 0x00, 0x43, 0x08, 0x00, 0x80, 0xc1, 0x40, 0x08,
   0x03, 0x00, 0x3e, 0x40, 0x10, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00
};
static const JConstBitmap okButtonBitmap = { 40,20, okButtonData };


static unsigned char checkboxData[] =
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xe0, 0x03, 0x00, 0xf0, 0x03,
   0x00, 0xf8, 0x03, 0x00, 0xfc, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x1e, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x07, 0x00, 0x8e, 0x03, 0x00, 0x9f, 0x03, 0x00,
   0xfe, 0x01, 0x00, 0xf8, 0x01, 0x00, 0xf0, 0x01, 0x00, 0xe0, 0x00, 0x00,
   0xc0, 0x00, 0x00, 0x40, 0x00, 0x00
};
static const JConstBitmap checkboxBitmap = { 18,18, checkboxData };

/******************************************************************************
 Constructor

 ******************************************************************************/

TestButtonsDialog::TestButtonsDialog
	(
	JXWindowDirector* supervisor
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow();
}

/******************************************************************************
 Destructor

 ******************************************************************************/

TestButtonsDialog::~TestButtonsDialog()
{
}

/******************************************************************************
 BuildWindow (private)

 ******************************************************************************/

void
TestButtonsDialog::BuildWindow()
{
	JXImageRadioButton* brb[ kSmileyBitmapCount ];

// begin JXLayout

    JXWindow* window = new JXWindow(this, 270,240, "");
    assert( window != NULL );
    SetWindow(window);

    JXStaticText* obj1 =
        new JXStaticText("Radio group #1:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 150,20, 85,20);
    assert( obj1 != NULL );
    obj1->SetFontSize(10);

    JXStaticText* obj2 =
        new JXStaticText("Radio group #2:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 25,135, 85,20);
    assert( obj2 != NULL );
    obj2->SetFontSize(10);

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 40,200, 70,30);
    assert( cancelButton != NULL );
    cancelButton->SetFontName(JXGetTimesFontName());
    const JFontStyle cancelButton_style(kTrue, kFalse, 0, kFalse, (GetColormap())->GetRedColor());
    cancelButton->SetFontStyle(cancelButton_style);

    JXImageButton* okButton =
        new JXImageButton(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 159,199, 72,32);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXTextCheckbox* tcb =
        new JXTextCheckbox("Text checkbox", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,25, 120,20);
    assert( tcb != NULL );
    tcb->SetNormalColor((GetColormap())->GetRedColor());
    tcb->SetPushedColor((GetColormap())->GetBlueColor());

    JXImageCheckbox* bcb =
        new JXImageCheckbox(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 60,90, 22,22);
    assert( bcb != NULL );

    itsRG1 =
        new JXRadioGroup(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 150,40, 104,134);
    assert( itsRG1 != NULL );

    itsRG2 =
        new JXRadioGroup(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 25,155, 102,36);
    assert( itsRG2 != NULL );

    brb[0] =
        new JXImageRadioButton(1, itsRG2,
                    JXWidget::kHElastic, JXWidget::kVElastic, 5,5, 22,22);
    assert( brb[0] != NULL );

    brb[1] =
        new JXImageRadioButton(2, itsRG2,
                    JXWidget::kHElastic, JXWidget::kVElastic, 27,5, 22,22);
    assert( brb[1] != NULL );

    brb[2] =
        new JXImageRadioButton(3, itsRG2,
                    JXWidget::kHElastic, JXWidget::kVElastic, 49,5, 22,22);
    assert( brb[2] != NULL );

    brb[3] =
        new JXImageRadioButton(4, itsRG2,
                    JXWidget::kHElastic, JXWidget::kVElastic, 71,5, 22,22);
    assert( brb[3] != NULL );

    JXTextRadioButton* trb1 =
        new JXTextRadioButton(1, "Choice 1", itsRG1,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,10, 80,20);
    assert( trb1 != NULL );

    JXTextRadioButton* trb2 =
        new JXTextRadioButton(2, "Choice 2", itsRG1,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,40, 80,20);
    assert( trb2 != NULL );

    JXTextRadioButton* trb3 =
        new JXTextRadioButton(3, "Choice 3", itsRG1,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,70, 80,20);
    assert( trb3 != NULL );

    JXStaticText* obj3 =
        new JXStaticText("Image checkbox", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 25,115, 90,20);
    assert( obj3 != NULL );
    obj3->SetFontSize(10);
    const JFontStyle obj3_style(kFalse, kFalse, 0, kFalse, (GetColormap())->GetGreenColor());
    obj3->SetFontStyle(obj3_style);

    JXTextCheckbox* dtcb =
        new JXTextCheckbox("Inactive", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,50, 120,20);
    assert( dtcb != NULL );
    dtcb->SetNormalColor((GetColormap())->GetRedColor());
    dtcb->SetPushedColor((GetColormap())->GetBlueColor());

    JXTextRadioButton* dtrb =
        new JXTextRadioButton(4, "Inactive", itsRG1,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,100, 80,20);
    assert( dtrb != NULL );

// end JXLayout

	window->SetTitle("Testing Buttons");
	SetButtons(okButton, cancelButton);

	dtcb->Deactivate();
	dtrb->Deactivate();

	JXColormap* colormap = GetColormap();

	okButton->SetBitmap(okButtonBitmap, colormap->GetBlueColor());
	bcb->SetBitmap(checkboxBitmap, colormap->GetGreenColor());
	bcb->SetHint("Image checkbox hint");

	static const JColorIndex kRadioButtonColor[] =
	{
		colormap->GetWhiteColor(),
		colormap->GetRedColor(),
		colormap->GetBlueColor(),
		colormap->GetBlackColor()
	};

	static const JCharacter* kRadioButtonHint[] =
	{
		"Happy", "Amused", "Neutral", "Sad"
	};

	for (JIndex i=0; i<kSmileyBitmapCount; i++)
		{
		brb[i]->SetBitmap(kSmileyBitmap[i], kRadioButtonColor[i]);
		brb[i]->SetHint(kRadioButtonHint[i]);
		}

	ListenTo(itsRG1);
}

/******************************************************************************
 Receive (protected)

 ******************************************************************************/

void
TestButtonsDialog::Receive
	(
	JBroadcaster*	sender,
	const Message&	message
	)
{
	if (sender == itsRG1 && message.Is(JXRadioGroup::kSelectionChanged))
		{
		const JXRadioGroup::SelectionChanged* selection =
			dynamic_cast(const JXRadioGroup::SelectionChanged*, &message);
		assert( selection != NULL );
		if (selection->GetID() == 2)
			{
			(JGetUserNotification())->DisplayMessage("Good choice!");
			}
		}
	else
		{
		JXDialogDirector::Receive(sender, message);
		}
}

/******************************************************************************
 OKToDeactivate (virtual protected)

 ******************************************************************************/

JBoolean
TestButtonsDialog::OKToDeactivate()
{
	if (!JXDialogDirector::OKToDeactivate())
		{
		return kFalse;
		}

	if (!Cancelled() && itsRG2->GetSelectedItem() == kSmileyBitmapCount)
		{
		(JGetUserNotification())->DisplayMessage("Hey!  Cheer up!");
		}

	return kTrue;
}
