/* $Id: ConRes.h,v 1.1.1.1 2001/04/09 13:32:14 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_conres_h)
#define xarm_conres_h

#include <Xarm/Base.h>

class FormConstraintResources : public WObjectClass { 
 protected:
   FormConstraintResources() {}
 public:
   /* constraint resources */
   void bottomAttachment(unsigned char val) { XARM_SET_VALUE(XmNbottomAttachment); }
   unsigned char bottomAttachment() const   { XARM_GET_VALUE(unsigned char, XmNbottomAttachment); }
   void bottomOffset(int val)               { XARM_SET_VALUE(XmNbottomOffset); }
   int bottomOffset() const                 { XARM_GET_VALUE(int, XmNbottomOffset); }
   void bottomPosition(int val)             { XARM_SET_VALUE(XmNbottomPosition); }
   int bottomPosition() const               { XARM_GET_VALUE(int, XmNbottomPosition); }
   void bottomWidget(Widget val)            { XARM_SET_VALUE(XmNbottomWidget); }
   Widget bottomWidget() const              { XARM_GET_VALUE(Widget, XmNbottomWidget); }
   void leftAttachment(unsigned char val)   { XARM_SET_VALUE(XmNleftAttachment); }
   unsigned char leftAttachment() const     { XARM_GET_VALUE(unsigned char, XmNleftAttachment); }
   void leftOffset(int val)                 { XARM_SET_VALUE(XmNleftOffset); }
   int leftOffset() const                   { XARM_GET_VALUE(int, XmNleftOffset); }
   void leftPosition(int val)               { XARM_SET_VALUE(XmNleftPosition); }
   int leftPosition() const                 { XARM_GET_VALUE(int, XmNleftPosition); }
   void leftWidget(Widget val)              { XARM_SET_VALUE(XmNleftWidget); }
   Widget leftWidget() const                { XARM_GET_VALUE(Widget, XmNleftWidget); }
   void resizable(Boolean val)              { XARM_SET_VALUE(XmNresizable); }
   Boolean resizable() const                { XARM_GET_VALUE(Boolean, XmNresizable); }
   void rightAttachment(unsigned char val)  { XARM_SET_VALUE(XmNrightAttachment); }
   unsigned char rightAttachment() const    { XARM_GET_VALUE(unsigned char, XmNrightAttachment); }
   void rightOffset(int val)                { XARM_SET_VALUE(XmNrightOffset); }
   int rightOffset() const                  { XARM_GET_VALUE(int, XmNrightOffset); }
   void rightPosition(int val)              { XARM_SET_VALUE(XmNrightPosition); }
   int rightPosition() const                { XARM_GET_VALUE(int, XmNrightPosition); }
   void rightWidget(Widget val)             { XARM_SET_VALUE(XmNrightWidget); }
   Widget rightWidget() const               { XARM_GET_VALUE(Widget, XmNrightWidget); }
   void topAttachment(unsigned char val)    { XARM_SET_VALUE(XmNtopAttachment); }
   unsigned char topAttachment() const      { XARM_GET_VALUE(unsigned char, XmNtopAttachment); }
   void topOffset(int val)                  { XARM_SET_VALUE(XmNtopOffset); }
   int topOffset() const                    { XARM_GET_VALUE(int, XmNtopOffset); }
   void topPosition(int val)                { XARM_SET_VALUE(XmNtopPosition); }
   int topPosition() const                  { XARM_GET_VALUE(int, XmNtopPosition); }
   void topWidget(Widget val)               { XARM_SET_VALUE(XmNtopWidget); }
   Widget topWidget() const                 { XARM_GET_VALUE(Widget, XmNtopWidget); }

};

class FrameConstraintResources : public FormConstraintResources { 
 protected:
   FrameConstraintResources() {}
 public:
   /* constraint resources */
   void childType(unsigned char val)                { XARM_SET_VALUE(XmNchildType); }
   unsigned char childType() const                  { XARM_GET_VALUE(unsigned char, XmNchildType); }
   void childHorizontalAlignment(unsigned char val) { XARM_SET_VALUE(XmNchildHorizontalAlignment); }
   unsigned char childHorizontalAlignment() const   { XARM_GET_VALUE(unsigned char, XmNchildHorizontalAlignment); }
   void childHorizontalSpacing(unsigned char val)   { XARM_SET_VALUE(XmNchildHorizontalSpacing); }
   unsigned char childHorizontalSpacing() const     { XARM_GET_VALUE(unsigned char, XmNchildHorizontalSpacing); }
   void childVerticalAlignment(unsigned char val)   { XARM_SET_VALUE(XmNchildVerticalAlignment); }
   unsigned char childVerticalAlignment() const     { XARM_GET_VALUE(unsigned char, XmNchildVerticalAlignment); }
};

class PanedWindowConstraintResources : public FrameConstraintResources {
 protected:
   PanedWindowConstraintResources() {}
 public:
   /* constraints */
   void allowResize(Boolean val)   { XARM_SET_VALUE(XmNallowResize); }
   Boolean allowResize() const     { XARM_GET_VALUE(Boolean, XmNallowResize); }
   void paneMaximum(Dimension val) { XARM_SET_VALUE(XmNpaneMaximum); }
   Dimension paneMaximum() const   { XARM_GET_VALUE(Dimension, XmNpaneMaximum); }
   void paneMinimum(Dimension val) { XARM_SET_VALUE(XmNpaneMinimum); }
   Dimension paneMinimum() const   { XARM_GET_VALUE(Dimension, XmNpaneMinimum); }
   void positionIndex(short val)   { XARM_SET_VALUE(XmNpositionIndex); }
   short positionIndex() const     { XARM_GET_VALUE(short, XmNpositionIndex); }
   void skipAdjust(Boolean val)    { XARM_SET_VALUE(XmNskipAdjust); }
   Boolean skipAdjust() const      { XARM_GET_VALUE(Boolean, XmNskipAdjust); }
};

class RowColumnConstraintResources : public PanedWindowConstraintResources {
 protected:
   RowColumnConstraintResources() {}
 public:
   /* constraint resources */
   void positionIndex(short val) { XARM_SET_VALUE(XmNpositionIndex); }
   short positionIndex() const   { XARM_GET_VALUE(short, XmNpositionIndex); }
};

class ConstraintResources : public RowColumnConstraintResources {
 protected:
   ConstraintResources() {}
};

#endif
