/*
 Copyright (C) 1997, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_m2spinbox_h)
#define xarm_m2spinbox_h

#include <Xm/SpinB.h>
#include <Xarm/Manager.h>

class SpinBoxClass : public ManagerClass {
 protected:
   SpinBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmSpinBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmSpinBox"; }

 public:
   /* callbacks */
   void modifyVerifyCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNmodifyVerifyCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNvalueChangedCallback); }

   /* resources */

   void arrowLayout(unsigned char val)              { XARM_SET_VALUE(XmNarrowLayout); }
   unsigned char arrowLayout() const                { XARM_GET_VALUE(unsigned char, XmNarrowLayout); }
   void arrowSize(Dimension val)                    { XARM_SET_VALUE(XmNarrowSize); }
   Dimension arrowSize() const                      { XARM_GET_VALUE(Dimension, XmNarrowSize); }
   void defaultArrowSensitivity(unsigned char val)  { XARM_SET_VALUE(XmNdefaultArrowSensitivity); }
   unsigned char defaultArrowSensitivity() const    { XARM_GET_VALUE(unsigned char, XmNdefaultArrowSensitivity); }
   void detailShadowThickness(Dimension val)        { XARM_SET_VALUE(XmNdetailShadowThickness); }
   Dimension detailShadowThickness() const          { XARM_GET_VALUE(Dimension, XmNdetailShadowThickness); }
   void initialDelay(unsigned int val)              { XARM_SET_VALUE(XmNinitialDelay); }
   unsigned int initialDelay() const                { XARM_GET_VALUE(unsigned int, XmNinitialDelay); }
   void marginHeight(Dimension val)                 { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const                   { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)                  { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const                    { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void repeatDelay(unsigned int val)               { XARM_SET_VALUE(XmNrepeatDelay); }
   unsigned int repeatDelay() const                 { XARM_GET_VALUE(unsigned int, XmNrepeatDelay); }
   void spacing(Dimension val)                      { XARM_SET_VALUE(XmNspacing); }
   Dimension spacing() const                        { XARM_GET_VALUE(Dimension, XmNspacing); }
   void arrowSensitivity(unsigned char val)         { XARM_SET_VALUE(XmNarrowSensitivity); }
   unsigned char arrowSensitivity() const           { XARM_GET_VALUE(unsigned char, XmNarrowSensitivity); }

   // In the Motif 2.0 version of the SpinBox, the following
   // resources are set on each child of the spinbox. Therefore
   // we must pass the child widget as a parameter.

   void decimalPoints(Widget w, short val)           { XARM_SET_VALUE_W(XmNdecimalPoints); }
   short decimalPoints(Widget w) const               { XARM_GET_VALUE_W(short, XmNdecimalPoints); }
   void incrementValue(Widget w, int val)            { XARM_SET_VALUE_W(XmNincrementValue); }
   int incrementValue(Widget w) const                { XARM_GET_VALUE_W(int, XmNincrementValue); }
   void maximumValue(Widget w, int val)              { XARM_SET_VALUE_W(XmNmaximumValue); }
   int maximumValue(Widget w) const                  { XARM_GET_VALUE_W(int, XmNmaximumValue); }
   void minimumValue(Widget w, int val)              { XARM_SET_VALUE_W(XmNminimumValue); }
   int minimumValue(Widget w) const                  { XARM_GET_VALUE_W(int, XmNminimumValue); }
   void numValues(Widget w, int val)                 { XARM_SET_VALUE_W(XmNnumValues); }
   int numValues(Widget w) const                     { XARM_GET_VALUE_W(int, XmNnumValues); }
   void position(Widget w, int val)                  { XARM_SET_VALUE_W(XmNposition); }
   int position(Widget w) const                      { XARM_GET_VALUE_W(int, XmNposition); }
   unsigned char spinBoxChildType(Widget w) const    { XARM_GET_VALUE_W(unsigned char, XmNspinBoxChildType); }
   void values(Widget w, const XmStringTable val)    { XARM_SET_VALUE_W(XmNvalues); }
   XmStringTable values(Widget w) const              { XARM_GET_VALUE_W(XmStringTable, XmNvalues); }

   /* Extra functionality */
   void values(Widget, const char **, const int c);
};

typedef XarmFuncWidget<SpinBoxClass, XmCreateSpinBox, true> SpinBox;

#endif
