/*
 Copyright (C) 1997, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_xarmarg_h)
#define xarm_xarmarg_h

#include <vector>
#include <X11/Intrinsic.h>
#include <Xarm/Xarm.h>

// We need to forward-declare the base Xarm widget class
class WObjectClass;

struct typedArg {
    String    resource_name;
    String    type_name;
    XtPointer value;
    unsigned  val_size;
};

class XarmArg {

private:

#if defined(XARM_HAS_NAMESPACES)
    std::vector<Arg>      argVec;
    std::vector<typedArg> typedArgVec;
#else
    vector<Arg>      argVec;
    vector<typedArg> typedArgVec;
#endif

    ArgList theArgs;

    unsigned int sizeOfType(String);

    // Avoid copying

    XarmArg &operator=(const XarmArg &);
    XarmArg(const XarmArg &);

public:

    XarmArg() : theArgs(NULL) {}
    ~XarmArg() { delete [] theArgs; }

    Cardinal count()  { return argVec.size(); }
    void     reset();
    ArgList  getArgs();
    void     setTypedArgs(Widget);
    bool     hasTypedArgs() { return (typedArgVec.size() > 0); }

    XarmArg &operator()(String, XtArgVal);
    XarmArg &operator()(String, String, XtPointer, unsigned int);
    XarmArg &operator()(String name, String resType, const char *val, unsigned int val_size)
                       { return operator()(name, resType, (XtPointer)val, val_size); }
    XarmArg &operator()(String name, XtPointer      value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, signed   int   value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, unsigned int   value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, unsigned long  value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, signed   char  value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, unsigned char  value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, const char    *value) { return operator()(name, (XtArgVal)value); }

    // This one allows you to use Xarm object pointers as widgets when setting resources.
    //
    // i.e.:  PushButton *okButton;
    //        XarmArg args(XmNtopWidget, okButton);

    XarmArg &operator()(String name, const WObjectClass *value);
};

#endif
