#include <Xclasses/Xclasses.h>
#include <stdio.h>
#include <string.h>


XCprogram myprg("callback_example",
                XCP_Author,"Jrgen Schmitz",
                XCP_Copyright,"only copied with Xclasses, free to modify for own use",
                XCP_Version,"1.0",
                XCP_EMail,"schmitzj@fsai.fh-trier.de",
                XCP_WWW,"http://fsai.fh-trier.de/~schmitzj/computer/Xclasses",
                XCP_OwnHTML,"This is an example of Xclasses using callbacks for gadget"
                            "identification.<p>"
                            "<ul><li>the gadgets have a callback (maybe different or the same)"
                            "<li>the program ends if all windows are closed"
                            "</ul>",
                XCP_Desc,"Example program for Xclasses",
                XCP_Done);


void finger(gadget *g,int i)
{
    char uname[9];
    FILE *command;
    char com_str[30]="finger ";
    char buffer[200],*c;
    int pos;
    input *inp_name=(input*)FindObject(".username");
    textbox *txt_output=(textbox*)FindObject(".textoutput");
    appwindow *mywin=(appwindow*)FindObject(".mainwindow");

    inp_name->Input(uname);

    strcat(com_str,uname);
    if (command=popen(com_str,"r"))
    {
        txt_output->AppendText("\n\n");
        while (!feof(command))
        {
            if (fgets(buffer,sizeof(buffer),command))
            {
                c=buffer;
                pos=0;
                while (*c)
                {
                    if (*c=='\t')
                    {
                        *c=' ';
                    }
                    if (*c=='\n')
                        pos=0;
                    else
                        pos++;
                    c++;
                }
                txt_output->AppendText(buffer);
                mywin->Update();
            }
        }
        pclose(command);
    }
}
void quit(gadget *g,int i)
{
    appwindow *mywin=(appwindow*)FindObject(".mainwindow");
    mywin->Close();
}
void handleMenu(gadget *g,int i)
{
//  menu *mymenu=(menu*)FindObject(".menu");
    menu *mymenu=(menu*)g;
    appwindow *mywin=(appwindow*)FindObject(".mainwindow");
    switch(mymenu->Selection())
    {
        case 0x01000001:
            mywin->Close();
            break;
    }
}
int main(int argc, char *argv[])
{
    appwindow *mywin=new appwindow;
    mywin->InitSize(10,10,30);
    if (!mywin->Init(argc,argv))
    {
        printf("Error:\nCan't open display %s\n\n",mywin->DisplayName());
        exit(1);
    }
    mywin->Name("mainwindow");

    menu *mymenu=new menu;
    mymenu->AddMenu("Program");
    mymenu->Add("Quit","q",1);
    mymenu->Callback(handleMenu);

    group *maingroup=new group; 
    maingroup->Vert();
    maingroup->YDistance(4);
    maingroup->Name("maingroup");
    
    bordergroup *inputgroup=new bordergroup;
    maingroup->Add(inputgroup);
     inputgroup->Name("inputgroup");
     inputgroup->Title("Finger");
     inputgroup->Horiz();
     inputgroup->HelpText("Username to finger\nor empty for all logged in useds");

     input *inp_name=new input;
     inputgroup->Add(inp_name);
      inp_name->Name("username");
      inp_name->MaxChars(8);
      inp_name->Text("Username");
      inp_name->AlwaysMode();
      inp_name->Callback(finger);

      fbutton *but_start=new fbutton;
     inputgroup->Add(but_start);
      but_start->Name("fingerbutton");
      but_start->Text("Finger");
      but_start->Weight(50);
      but_start->Callback(finger);

    textbox *txt_output=new textbox;
    maingroup->Add(txt_output);
     txt_output->Name("textoutput");
     txt_output->ReadOnly();
     txt_output->AlwaysShowLast();

    ruler *rl_1=new ruler;
    maingroup->Add(rl_1);

    fbutton *but_quit=new fbutton;
    maingroup->Add(but_quit);
     but_quit->Name("quit");
     but_quit->Text("Quit");
     but_quit->Callback(quit);

    mywin->Callback();
    mywin->SetGroup(maingroup);
    mywin->SetMenu(mymenu);

    mywin->Create();
    appwindow::NextEvent();
    return 0;
}

