
/* 	Xtk constants and typedefs needed to use Xm++ without including
	the X11 includes...
*/
	
#include <string.h>
#include <strstream.h>
#include <stdlib.h>
#include <rci_clt.h>

#define XtNcallback	 	"callback"

typedef unsigned long XID;

typedef XID Window;
typedef XID Drawable;
typedef XID Font;
typedef XID Pixmap;
typedef XID Cursor;
typedef XID Colormap;
typedef XID GContext;
typedef XID KeySym;

class XmRciController;

typedef XmRciController* Widget;
typedef void* XtAppContext;
typedef void* XrmDatabase;
typedef void* GC;

typedef int Display;
typedef int Screen;

typedef char Boolean;
typedef long XtArgVal;
typedef long XrmValue;
typedef void* XtPointer;
typedef unsigned short Dimension;
typedef short Position;

typedef char* String;
typedef char* XString;
typedef char* XmString;

typedef struct {
	char dum[200];
} XGCValues;

typedef struct {
    XString      name;
    XtArgVal    value;
} Arg, *ArgList;

class XmObject;

#define cbName2Reason(x) (strcmp(x, "callback") ? 2 : 1)

struct XmRciCallback
{
	int reason;
	char* name;
	void* client_data;
	
	XmRciCallback(int r, void* d, char* n = NULL)	{ reason = r; client_data = d; name = n ? _mkstr(n) : n; }
	XmRciCallback(char* r, void* d, char* n = NULL)	{ reason = cbName2Reason(r); client_data = d; name = n ? _mkstr(n) : n; }
	~XmRciCallback()				{ delete name; delete client_data; }

	int matches(int r, char* n = "")		{ return(reason == r && (name ? _cmpstr(name, n) : 1)); }

	int equ(int r, void* d, char* n = "")		{ return(reason == r && d == client_data && (name ? _cmpstr(name, n) : 1)); }
	int equ(char* r, void* d, char* n = "")		{ return(reason == cbName2Reason(r) && d == client_data && (name ? _cmpstr(name, n) : 1)); }
};

extern bool rciRootApp;

class XmRciController : public RciController
{
	char* name;		// used only in child widgets...
	bool rciOk;
	bool rciRealized;
	bool rciToplevel;
	bool rciRoot;
	XmObject* obj;
	mincoll<XmRciCallback*>* callbacks;
	XmRciController* parent;
	mincoll<XmRciController*>* children;

	void setName(char* n)	{ delete name; name = _mkstr(n); }
friend class XmDialogPane;
friend class XmListBox;
friend class XmEdit;
friend class XmComboBox;
	void setParent(XmRciController* p)	{ if(parent) parent->removeChild(this); parent = NULL; if(p) { parent = p; p->addChild(this); } }
friend class XmApp;
	void setRoot()		{ rciRoot = TRUE; }
friend class XmDialog;
friend class XmUserDialog;
	void setToplevel()	{ rciToplevel = TRUE; }
public:
	XmRciController(XmObject*, char*, XmRciController*);
	~XmRciController();

	bool execCreate()	{ return(rciOk = execCmd()); }
	bool execRealize()	{ return(rciRealized = execCmd()); }
	bool execIfVisible()	{ return(rciRealized ? execCmd() : FALSE); }
	
	bool addCbk(char* n, void* d, char* = NULL);
	bool removeCbk(char* n, void* d, char* = NULL);
	void callCallbacks(int, char*);	// call every cb in the list...

	char* getName()			{ return(name); }
	XmRciController* getParent()	{ return(parent); }
	char* getText()			{ return("NotImplemented"); }

	void addChild(XmRciController*);
	void removeChild(XmRciController*);
	XmRciController* getChild(char*);	// childName or one of names matches!
	bool isOk()			{ return(rciOk); } // TRUE if Rci - created...
	bool isRealized()		{ return(rciRealized || rciToplevel ? TRUE : FALSE); }
	XmObject* getXmObj()		{ return(obj); }

	void processArgs(ArgList, int);
	char* getConfigValue(char*)	{ return(""); }
};

#define ANY_CALLBACK	XtNcallback

#define getObjName(x)      (x->getName())
#define getObjText(x)      (x->getText())
#define getObjParent(x)    (x->getParent())
#define getObjChild(x, n)  (x->getChild(n))
#define isObjRealized(x)   (x->isRealized())

#define XtParent(x) getObjParent(x)
