#include <stream.h>
#include <strstream.h>
#include <stdlib.h>

#include <filemgr.h>

#include <xmObject.h>

#include <rda_clt.h>
#include <minlib.h>

#ifndef ASCII
#define errout cerr
#endif

char* extractPath(char*);
char* extractFilename(char*);
char* makePath(char*, char*);

class DemoWindow : public XmDialogWindow	// XmWindow
{
	rdaFileType type;
	rdaTransferMode mode;
	int pendingOp;	// 0 none, 1 get, 2 put
	string localpath, remotepath;
	char* pendingName;
	mincoll<RDATransferClient*> transfers;

	bool initWindowSize(int&, int&, int& nw, int& nh)	{ nw = 300; nh = 200; return(TRUE); } 

	void initialize();

	void cmd(char*);
	void quit(void*);
public:
	DemoWindow() : XmDialogWindow("RDA Demo")	// XmWindow("RDA Demo")
	{ type = RDA_BINARY; mode = RDA_BACKGROUND; pendingOp = 0; }

	void rdaCallback(rdaCbData*);

	void showOutput(char* txt)		{ edit("display")->setText(txt); }
	void showOutput(ostrstream& out)	{ out.put('\0'); edit("display")->setText(out.str()); }
	void fileSelected(char*);
	void runGet(char*, char*);
	void runPut(char*, char*);
	void transferCallback(RDATransferClient*, rdaCallbackReason);
};

class RdaFileSelectDlg : public XmUserDialog
{
	DemoWindow* mainWin;
	string path, defaultStr;
	FileMgr* fm;

	bool initWindowSize(int&, int&, int&, int&);
	void createContents();
	void initContents();

	void refresh();
	void cmd(char*);
	void xcmd(char*);
public:
	RdaFileSelectDlg(DemoWindow* parent, char* p, char* dflt) : XmUserDialog("RDA File Selector", parent, 0x0L | XmSbordered | XmSmoveable | XmStitled | XmSsysMenu | XmSdlgAppModal)
	{ mainWin = parent; path = p; defaultStr = dflt; fm = NULL; }
};


// implementation ///////////////////////////////////////////////////////

char* extractPath(char* p)
{
static string tmppath;

	tmppath = p;
	char* sep;
	if((sep = strrchr(tmppath, '/')) || (sep = strrchr(tmppath, '\\')))
	{	*(sep + 1) = 0;
		return(tmppath);
	}
	tmppath = "";
	return(tmppath);
}

char* extractFilename(char* p)
{
static string tmppath;

	tmppath = p;
	char* sep;
	if((sep = strrchr(p, '/')) || (sep = strrchr(p, '\\')))
		tmppath = (sep + 1);
	return(tmppath);
}

char* makePath(char* p, char* f)
{
static string tmppath;

	tmppath = p;
	if(strrchr(p, '/'))
		tmppath += (f ? f : "*");
	else if(strrchr(p, '\\'))
		tmppath += (f ? f : "*.*");
	else
		tmppath = (f ? f : "");
	return(tmppath);
}

/////////////////////////////////////////////////////////////////////


void demoTransferCallback(rdaCbData* cb)
{
	((DemoWindow*)cb->clientData)->transferCallback(
		(RDATransferClient*)cb->rdaObj, cb->reason);
}

void DemoWindow::initialize()
{
	XmDropdownMenu* m = createDropdownMenu();

	m->addLabels("&File", "&Test", NULL);

	m->setCurrentLabel("File");
	m->addItems(Entry("E&xit", CBK(DemoWindow, quit)), NULLENTRY);

	m->setCurrentLabel("Test");
	m->addItems(	Entry("demosetup", "&Setup...", CBK(DemoWindow, cmd)),
			NULLENTRY);
	m->addSeparator();
	m->addItems(	Entry("getdemo", "&Get...", CBK(DemoWindow, cmd)),
			Entry("putdemo", "&Put...", CBK(DemoWindow, cmd)),
			NULLENTRY);
//	addSubpane(Edit, "display");
	add(new XmEdit("display", 0, 30, 300, 160));
	edit("display")->setText(rdaInititalize() ?
		"Hello RDA User!!" :
		"RDA init failed.");
}

void DemoWindow::cmd(char* cn)
{
	if(strstr(cn, "setup"))
	{
	}
	else if(strstr(cn, "get"))
	{	pendingOp = 1;
		(new RdaFileSelectDlg(this, remotepath, ""))->open();
	}
	else if(strstr(cn, "put"))
	{	char* sfn;
		if(!(sfn = (new XmFileSelector(makePath(localpath, "*")))->promptFile()))
			return;
		pendingOp = 2;
		pendingName = sfn;
		localpath = extractPath(sfn);
		(new RdaFileSelectDlg(this, remotepath, extractFilename(sfn)))->open();
	}
}

void DemoWindow::fileSelected(char* fn)
{
	if(fn)
	{	remotepath = extractPath(fn);
		if(pendingOp == 1)
		{	char* tfn;
			if(tfn = (new XmFileSelector(makePath(localpath, "*"), "Store As", 
				extractFilename(fn)))->promptFile())
			{	localpath = extractPath(tfn);
				runGet(fn, tfn);
			}
		}
		else
			runPut(pendingName, fn);
	}
	pendingOp = 0;
	pendingName = "";
}
		

void DemoWindow::quit(void*)
{
	edit("display")->hide();
	destroyOnDelete();
	delete this;
}

void DemoWindow::runGet(char* sfn, char* tfn)
{
cerr << "get: " << sfn << " -> " << tfn << "...\n";
	RDATransferClient* transfer = new RDATransferClient;
	transfer->setCallback(&demoTransferCallback, this);
	transfers.add(transfer);
	showOutput(transfer->send(sfn, tfn, TRUE, type, mode) ? "Ok" : "Failed");
}

void DemoWindow::runPut(char* sfn, char* tfn)
{
	if(strrchr(sfn, '/'))
		tfn = (strrchr(sfn, '/') + 1);
	else if(strrchr(sfn, '\\'))
		tfn = (strrchr(sfn, '\\') + 1);
cerr << "put: " << sfn << " -> " << tfn << "...\n";
	RDATransferClient* transfer = new RDATransferClient;
	transfer->setCallback(&demoTransferCallback, this);
	transfers.add(transfer);
	showOutput(transfer->receive(sfn, tfn, TRUE, type, mode) ? "Ok" : "Failed");
}

void DemoWindow::transferCallback(RDATransferClient* c, rdaCallbackReason r)
{
/*
	cerr 	<< (c->getDirection() == 1 ? "receive" : "send") 
		<< " transfer " << c->getLocalPath() << " -> "
		<< c->getRemotePath();
*/
	switch(r)
	{	case RDA_CBK_ERROR:
		cerr << c->getRemotePath() << " ERROR: " << c->status()
			<< " - " << strerror(c->status()) << "\n";
		transfers.remove(c);
//		delete c;
		break;
		case RDA_CBK_PROGRESS:
		cerr << (c->getDirection() ? '>' : '<');
		break;
		case RDA_CBK_END_OF_TRANSFER:
		cerr << c->getRemotePath() << " " << c->getBytesTransferred()
			<< " bytes: ready." << "\n";
		transfers.remove(c);
//		delete c;
	}
}

// file select dialog ///////////////////////////////////////////

#include <rdafsdlg.C>

void RdaFileSelectDlg::initContents()
{
	listBox("lbxDirectories")->setCallback(this, CBK(RdaFileSelectDlg, cmd), TRUE, CB_OBJ_NAME);
	listBox("lbxDirectories")->setDoubleClickProc(this, CBK(RdaFileSelectDlg, xcmd), TRUE, CB_OBJ_NAME);
	listBox("lbxFiles")->setCallback(this, CBK(RdaFileSelectDlg, cmd), TRUE, CB_OBJ_NAME);
	listBox("lbxFiles")->setDoubleClickProc(this, CBK(RdaFileSelectDlg, xcmd), TRUE, CB_OBJ_NAME);
	pushButton("btnOk")->setCallback(this, CBK(RdaFileSelectDlg, xcmd), TRUE, CB_OBJ_NAME);
	pushButton("btnList")->setCallback(this, CBK(RdaFileSelectDlg, cmd), TRUE, CB_OBJ_NAME);
	pushButton("btnCancel")->setCallback(this, CBK(RdaFileSelectDlg, xcmd), TRUE, CB_OBJ_NAME);
	refresh();
}

void RdaFileSelectDlg::refresh()
{
	XmListBox* lbd = listBox("lbxDirectories"), * lbf = listBox("lbxFiles");
	mincoll<char*>* lines;
	char* aLine;
	int i;

	if(!fm)
	{	fm = new FileMgr("/");
		fm->cd(path);
	}
	lines = fm->ls(FM_SUBDIRS);
	lbd->clear();
	for(i = 0; aLine = lines->at(i); i++)
	{	lbd->add(aLine);
		delete aLine;
	}
	delete lines;
	lines = fm->ls(FM_FILES);
	lbf->clear();
	for(i = 0; aLine = lines->at(i); i++)
	{	lbf->add(aLine);
		delete aLine;
	}
	delete lines;
	edit("edtPath")->setText(fm->pwd());
	if(defaultStr.len())
	{	string fn(fm->pwd());
		fn += "/";
		fn += defaultStr;
		edit("edtValue")->setText(fn);
	}
}

char* fnptr;

void RdaFileSelectDlg::cmd(char* aStr)
{
	if(strstr(aStr, "Directories"))
	{	string dn(fm->pwd());
		dn += (dn == "/" ? "" : "/");
		dn += listBox("lbxDirectories")->selectedItem();
		edit("edtPath")->setText(dn);
	}
	else if(strstr(aStr, "List"))
	{	char* selDir;
		if(!(selDir = edit("edtPath")->getText()))
			return;
		fm->cd(selDir);
		refresh();
	}
	else if(strstr(aStr, "Files"))
	{	string fn(edit("edtPath")->getText());
		fn += (fn == "/" ? "" : "/");
		fn += listBox("lbxFiles")->selectedItem();
		edit("edtValue")->setText(fn);
	}
}

void RdaFileSelectDlg::xcmd(char* aStr)
{
	fnptr = NULL;
	if(strstr(aStr, "Directories"))
	{	cmd("Directories");
		cmd("List");
		return;
	}
	if(strstr(aStr, "Files"))
		cmd("Files");
	if(strstr(aStr, "Ok") || strstr(aStr, "Files"))
		fnptr = edit("edtValue")->getText();
	delete this;
	mainWin->fileSelected(fnptr);
}

// application init method ///////////////////////////////////////////

void XmApp::initialize()
{
	(new DemoWindow)->open();
};

