// gem_image.h
// 
// Machine dependant low-level image data format.  
// This is used for loading files from disk into memory.  The machine 
// dependant gem image code converts this data into something usable, and
// takes care of displaying it, and so on.

// A generic colormap entry.
#ifndef GEM_IMAGE_H
#define GEM_IMAGE_H

class Am_RGB_Value
{
public:
  Am_RGB_Value (): red(0), green(0), blue(0) {}
  Am_RGB_Value (short int r, short int g, short int b): 
    red(r), green(g), blue(b) {}
  unsigned short red;
  unsigned short green;
  unsigned short blue;
};

// Information about the image
class Am_Image_Info
{
public:
  Am_Image_Info ():
    width(0), height(0), depth(0), num_colors(0) {}
  Am_Image_Info (int w, int h, int d, int n):
    width(w), height(h), depth(d), num_colors(n) {}
  Am_Image_Info (Am_Image_Info &proto):
    width(proto.width), height(proto.height), depth(proto.depth), 
    num_colors(proto.num_colors) {}
  unsigned short width;
  unsigned short height;
  int depth;
  int num_colors;
};

// An abstract generic image class.  Derive particular classes 
// (ie Am_GIF_Image) from this class. 

class Am_Generic_Image
{
public:
  // The creator for subclasses loads an image from a file if possible, 
  // returning a valid image for success or NULL for failure.
  //  static Am_Generic_Image* Create(char* filename);
  
  Am_Generic_Image():
    imdata (NULL), color_map(NULL) {}
  Am_Generic_Image (unsigned char* data, int width, int height, int depth):
    imdata(data), iminfo(width, height, depth, 0), color_map(NULL) {}
  Am_Generic_Image (Am_Generic_Image* proto):
    iminfo(proto->iminfo), color_map(proto->color_map) {
      // bug: assumes one byte per pixel.
      imdata = new unsigned char[iminfo.width * iminfo.height];
      memcpy (imdata, proto->imdata, iminfo.width * iminfo.height);
  }
  ~Am_Generic_Image () {
    if (imdata!= NULL) delete[] imdata; 
    if (color_map != NULL) delete[] color_map; }
protected:
  // data
  Am_Image_Info iminfo;
  Am_RGB_Value* color_map;
  unsigned char* imdata;
  
public:  
  inline void Get_Size (unsigned short &width, unsigned short &height) { 
    width = iminfo.width; 
    height = iminfo.height;  }
  inline unsigned char* Get_Data () {return imdata;}
  inline int Get_Depth () {return iminfo.depth;}
  inline void Set_Depth (int d) {iminfo.depth = d;}
  inline int Get_Color_Map (Am_RGB_Value*& map){
    map = color_map; return iminfo.num_colors; }
};

#endif
