// $Id: DialogWnd.cpp,v 1.8 1997/11/03 00:04:34 jharris Exp $

#include <qapp.h>
#include <qdatetm.h>
#include <qdir.h>
#include <qtstream.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qpixmap.h>

#include "ProjectWnd.h"
#include "DialogWnd.h"
#include "GenerateDialog.h"
#include "DlgParser.h"

#include "widget/DlgWidget.h"

#include "bmp/bitmaps.h"

#include "prop/DialogPropDialog.h"

#define Inherited QFrame

DialogWnd::DialogWnd( Dialog* dialog,
                      ProjectWnd *project,
                      const char* name )
    : 
    Inherited( NULL ),
    itsLayout( this, QBoxLayout::Down, 5, 0 ),
    itsMenu( this ),
    itsToolbar( this ),
    itsWidgetToolbar( this ),
    itsStatusBar( 20, this ),
    itsKbdAccel( this ),
    theProjectWnd( project ),
    itsDialog( dialog )
{
    QPixmap pixmap;

    setCaption( "Qt Architect" );
    //setFrameStyle( QFrame::Panel | QFrame::Raised );

    pixmap.loadFromData( QtArch_bmp_data, QtArch_bmp_len );
    setIcon( pixmap );
    setIconText( caption() );

    itsToolbar.setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
    itsWidgetToolbar.setFrameStyle( QFrame::WinPanel | QFrame::Sunken );

    itsMenu.setFrameStyle( WinPanel | Raised );

    // create a new widget frame
    itsActWidgetWnd = new WidgetFrame( this, "WidgetFrame" );
    itsActWidgetWnd->setFrameStyle( QFrame::Raised | QFrame::WinPanel );

    // Create new layout
    itsActLayout = new WidgetLayout( this, name );

    itsActLayout->SetDlgEditWnd( itsActWidgetWnd );
    itsActLayout->SetNoMove( itsActWidgetWnd );
    itsActLayout->EnableLayout();

    itsActWidgetWnd->show();

    // Dialog knows what to do when we want to close
    connect( this, SIGNAL(Closed()), dialog, SLOT(Hide()) );
  
    // Best for us if layout reports changes directly to dialog
    connect( itsActLayout, SIGNAL(Changed()), dialog, SLOT(LayoutChanged()) );

    connect( itsActLayout, SIGNAL(WidgetWndChanged()),SLOT(WidgetWndChanged()) );
    connect( itsActLayout, SIGNAL(WidgetGeometryChanged(int,int,int,int)),
	     SLOT(WidgetGeometryChanged(int,int,int,int)) );
    connect( itsActLayout, SIGNAL(WidgetSelected(const QString&,const QString&)),
	     SLOT(WidgetSelected(const QString&, const QString&)) );
    connect( itsActLayout, SIGNAL(WidgetDeselected()),
	     SLOT(WidgetDeselected()) );
    connect( itsActLayout, SIGNAL(UpdateScreen(int)), 
	     SLOT(UpdateScreen(int)) );

    // setup menu items
    QPopupMenu* file = new QPopupMenu;
    file->insertItem( "Save", dialog, SLOT(Save()), CTRL+Key_S );
    file->insertItem( "Generate Files", dialog, SLOT(Generate()), CTRL+Key_G );
    file->insertSeparator();
    file->insertItem( "Close", this, SLOT(Close()), CTRL+Key_Q );

    QPopupMenu* align = new QPopupMenu;
    itsAlignTopMenuId = 
	align->insertItem( "Align Top", itsActLayout, SLOT(AlignTop()),
			   ALT+Key_T );
    itsAlignBottomMenuId = 
	align->insertItem( "Align Bottom", itsActLayout, SLOT(AlignBottom()),
			   ALT+Key_B );
    itsAlignLeftMenuId = 
	align->insertItem( "Align Left", itsActLayout, SLOT(AlignLeft()),
			   ALT+Key_L );
    itsAlignRightMenuId = 
	align->insertItem( "Align Right", itsActLayout, SLOT(AlignRight()),
			   ALT+Key_R );
    align->insertSeparator();
    itsAlignWidthMenuId = 
	align->insertItem( "Same Width", itsActLayout, SLOT(SizeHorizontal()),
			   ALT+Key_W );
    itsAlignHeightMenuId = 
	align->insertItem( "Same Height", itsActLayout, SLOT(SizeVertical()),
			   ALT+Key_H );
    itsAlignSizeMenuId = 
	align->insertItem( "Same Size", itsActLayout, SLOT(SizeBothHV()),
			   ALT+Key_S );
  
    itsEditMenu = new QPopupMenu;
    cutMenuId = itsEditMenu->insertItem( "Cut", dialog, 
					 SLOT(CutSelectedWidgets()),
					 CTRL+Key_X );
    copyMenuId = itsEditMenu->insertItem( "Copy", dialog, 
					  SLOT(CopySelectedWidgets()),
					  CTRL+Key_C );
    pasteMenuId = itsEditMenu->insertItem( "Paste", dialog, 
					   SLOT(PasteSelectedWidgets()),
					   CTRL+Key_V );
    itsEditDeleteMenuId = 
	itsEditMenu->insertItem( "Delete", itsActLayout, 
				 SLOT(DeleteSelectedWidget()), CTRL+Key_D );
    itsEditMenu->insertSeparator();
    itsEditRaiseMenuId = 
	itsEditMenu->insertItem( "Raise", itsActLayout, 
				 SLOT(RaiseSelectedWidget()),
				 CTRL+Key_R );
    itsEditLowerMenuId = 
	itsEditMenu->insertItem( "Lower", itsActLayout, 
				 SLOT(LowerSelectedWidget()),
				 CTRL+Key_L );
    itsEditSizeToFitMenuId = 	
	itsEditMenu->insertItem( "Size to Fit", itsActLayout,
				 SLOT(SizeToFit()), CTRL+Key_F );
    itsEditMenu->insertItem( "Properties...", itsActLayout, 
			     SLOT(SelectedWidgetProperties()));
    itsEditMenu->insertSeparator();
    itsAlignMenuId = itsEditMenu->insertItem( "Align", align );
    itsEditMenu->insertSeparator();
    itsEditMenu->insertItem( "Grid...", itsActLayout, SLOT(OptionsGrid()));

    itsEditMenu->setItemEnabled( cutMenuId, FALSE );
    itsEditMenu->setItemEnabled( copyMenuId, FALSE );
    itsEditMenu->setItemEnabled( pasteMenuId, FALSE );

    QPopupMenu* newWidget = new QPopupMenu;
    newWidget->insertItem( "Button", this, SLOT(NewButton()) );
    newWidget->insertItem( "Button Group", this, SLOT(NewButtonGroup()),
			   CTRL+Key_4 );
    newWidget->insertItem( "Check Box", this, SLOT(NewCheckBox()),
			   CTRL+Key_2 );
    newWidget->insertItem( "Combo Box", this, SLOT(NewComboBox()),
			   CTRL+Key_9 );
    newWidget->insertItem( "Frame", this, SLOT(NewFrame()),
			   ALT+Key_4 );
    newWidget->insertItem( "Group Box", this, SLOT(NewGroupBox()) );
    newWidget->insertItem( "LCD Number", this, SLOT(NewLCDNumber()),
			   CTRL+Key_6 );
    newWidget->insertItem( "Label", this, SLOT(NewLabel()),
			   CTRL+Key_5 );
    newWidget->insertItem( "Line Edit", this, SLOT(NewLineEdit()),
			   CTRL+Key_7 );
    newWidget->insertItem( "List Box", this, SLOT(NewListBox()),
			   CTRL+Key_0 );
    newWidget->insertItem( "Menu Bar", this, SLOT(NewMenuBar()),
			   ALT+Key_5 );
    newWidget->insertItem( "Multi Line Edit", this, SLOT(NewMultiLineEdit()),
			   CTRL+Key_8 );
    newWidget->insertItem( "Progress Bar", this, SLOT(NewProgressBar()),
			   ALT+Key_3 );
    newWidget->insertItem( "Push Button", this, SLOT(NewPushButton()), 
			   CTRL+Key_1 );
    newWidget->insertItem( "Radio Button", this, SLOT(NewRadioButton()),
			   CTRL+Key_3 );
    newWidget->insertItem( "Scroll Bar", this, SLOT(NewScrollBar()),
			   ALT+Key_1 );
    newWidget->insertItem( "Slider", this, SLOT(NewSlider()),
			   ALT+Key_2 );
    newWidget->insertItem( "User Widget", this, SLOT(NewUser()),
			   ALT+Key_6 );

    QPopupMenu* layout = new QPopupMenu;
    itsLayoutBoxLayoutMenuId = 
	layout->insertItem( "Box Layout", itsActLayout, 
			    SLOT(InsertBoxLayout()) );
//     itsLayoutGridLayoutMenuId = 
// 	layout->insertItem( "Grid Layout", itsActLayout, 
// 			    SLOT(InsertGridLayout()) );
    itsLayoutSpacingMenuId = 
	layout->insertItem( "Spacing", itsActLayout, SLOT(InsertBoxSpacing()));
    itsLayoutStretchMenuId = 
	layout->insertItem( "Stretch", itsActLayout, SLOT(InsertBoxStretch()));
    
    itsMenu.insertItem( "Dialog", file );
    itsMenu.insertItem( "Edit", itsEditMenu );
    itsMenu.insertItem( "Widget", newWidget ); 
    itsMenu.insertItem( "Layout", layout );

    // insert menu into layout
    itsLayout.setMenuBar( &itsMenu );
 
    // setup toolbar with pixmaps

    // Have to keep tool tip text consistent with accelerators used 

    pixmap.loadFromData( SaveDialogs_bmp_data, SaveDialogs_bmp_len );
    itsToolbar.Insert( pixmap, dialog, SLOT(Save()),
		       "Save Dialog (Ctrl+S)", "Save the Dialog" );
    pixmap.loadFromData( Generate_bmp_data, Generate_bmp_len );
    itsToolbar.Insert( pixmap, dialog, SLOT(Generate()),
		       "Generate Dialog (Ctrl+G)", 
		       "Generate the code for the Dialog" );
  
    itsToolbar.InsertSeparator();

    pixmap.loadFromData( Cut_bmp_data, Cut_bmp_len );
    itsCutTbId = itsToolbar.Insert( pixmap, dialog, SLOT(CutSelectedWidgets()),
				    "Cut (Ctrl+X)",	
				    "Cut Selected Widgets to Clipboard" );
    pixmap.loadFromData( Copy_bmp_data, Copy_bmp_len );
    itsCopyTbId = 
	itsToolbar.Insert( pixmap, dialog, SLOT(CopySelectedWidgets()),
			   "Copy (Ctrl+C)",
			   "Copy Selected Widgets to Clipboard" );
    pixmap.loadFromData( Paste_bmp_data, Paste_bmp_len );
    itsPasteTbId = 
	itsToolbar.Insert( pixmap, dialog, SLOT(PasteSelectedWidgets()),
			   "Paste (Ctrl+V)",
			   "Paste Selected Widgets from Clipboard" );
    itsToolbar.EnableItem( itsCutTbId, FALSE );
    itsToolbar.EnableItem( itsCopyTbId, FALSE );
    itsToolbar.EnableItem( itsPasteTbId, FALSE );

    itsToolbar.InsertSeparator();
  
    pixmap.loadFromData( AlignTop_bmp_data, AlignTop_bmp_len );
    itsAlignTopTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(AlignTop()),
			   "Align Top (Alt+T)", 
			   "Align selected widgets on the top" );
    pixmap.loadFromData( AlignBottom_bmp_data, AlignBottom_bmp_len );
    itsAlignBottomTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(AlignBottom()),
			   "Align Bottom (Alt+B)",
			   "Align selected widgets on the bottom" );
    pixmap.loadFromData( AlignLeft_bmp_data, AlignLeft_bmp_len );
    itsAlignLeftTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(AlignLeft()),
			   "Align Left (Alt+L)",
			   "Align selected widgets on the left" );
    pixmap.loadFromData( AlignRight_bmp_data, AlignRight_bmp_len );
    itsAlignRightTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(AlignRight()),
			   "Align Right (Alt+R)",
			   "Align selected widgets on the right" );
    itsToolbar.InsertSeparator();
    pixmap.loadFromData( SizeHoriz_bmp_data, SizeHoriz_bmp_len );
    itsAlignWidthTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(SizeHorizontal()),
			   "Size Horizontally (Alt+H)",
			   "Resize selected widgets horizontally" );
    pixmap.loadFromData( SizeVertical_bmp_data, SizeVertical_bmp_len );
    itsAlignHeightTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(SizeVertical()),
			   "Size Vertically (Alt+V)",
			   "Resize selected widgets vertically" );
    pixmap.loadFromData( SizeHV_bmp_data, SizeHV_bmp_len );
    itsAlignSizeTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(SizeBothHV()),
			   "Size Horizontally and Vertically (Alt+S)",
			   "Resize selected widgets horizontally and vertically" );
    
    itsToolbar.InsertSeparator();
    
    pixmap.loadFromData( BoxLayout_bmp_data, BoxLayout_bmp_len );
    itsLayoutBoxLayoutTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(InsertBoxLayout()),
			   "Add a Box Layout",
			   "Add a Box Layout to the window" );
    pixmap.loadFromData( GridLayout_bmp_data, GridLayout_bmp_len );
//     itsLayoutGridLayoutTbId = 
// 	itsToolbar.Insert( pixmap, itsActLayout, SLOT(InsertGridLayout()),
// 				"Add a Grid Layout",
// 				"Add a Grid Layout to the window" );
    pixmap.loadFromData( BoxSpacing_bmp_data, BoxSpacing_bmp_len );
    itsLayoutSpacingTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(InsertBoxSpacing()),
			   "Add Spacing",
			   "Add spacing to a box layout" );
    pixmap.loadFromData( BoxStretch_bmp_data, BoxStretch_bmp_len );
    itsLayoutStretchTbId = 
	itsToolbar.Insert( pixmap, itsActLayout, SLOT(InsertBoxStretch()),
			   "Add Stretch",
			   "Add stretch to a box layout" );
  
    connect( &itsToolbar.GetToolTipGroup(), SIGNAL(showTip(const char*)),
	     SLOT(ShowToolTip(const char*)) );
    connect( &itsToolbar.GetToolTipGroup(), SIGNAL(removeTip()),
	     SLOT(RemoveToolTip()) );

    //itsLayout.addSpacing( 3 );

    // add toolbar to layout
    itsLayout.addWidget( &itsToolbar );
    itsToolbar.setMinimumSize( itsToolbar.size() );
    //itsToolbar.setMinimumSize( 0, itsToolbar.geometry().height() );


    // setup widget toolbar


    //pixmap.loadFromData( Button_bmp_data, Button_bmp_len );
    //itsToolbar.Insert( pixmap, this, SLOT(NewButton()), 
    //"New QButton", "Create a new QButton" );
    pixmap.loadFromData( PushButton_bmp_data, PushButton_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewPushButton()),
		       "New QPushButton (Ctrl+1)","Create a new QPushButton" );
    pixmap.loadFromData( CheckBox_bmp_data,CheckBox_bmp_len  );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewCheckBox()), 
		       "New QCheckBox (Ctrl+2)", "Create a new QCheckBox" );
    pixmap.loadFromData( RadioButton_bmp_data, RadioButton_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewRadioButton()),
		       "New QRadioButton (Ctrl+3)", 
		       "Create a new QRadioButton" );
    pixmap.loadFromData( ButtonGroup_bmp_data, ButtonGroup_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewButtonGroup()),
		       "New QButtonGroup (Ctrl+4)", 
		       "Create a new QButtonGroup" );
    pixmap.loadFromData( Label_bmp_data, Label_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewLabel()),
		       "New QLabel (Ctrl+5)", "Create a new QLabel" );
    pixmap.loadFromData( LCDNumber_bmp_data, LCDNumber_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewLCDNumber()),
		       "New QLCDNumber (Ctrl+6)", "Create a new QLCDNumber" );
    pixmap.loadFromData( LineEdit_bmp_data, LineEdit_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewLineEdit()),
		       "New QLineEdit (Ctrl+7)", "Create a new QLineEdit" );
    pixmap.loadFromData( MultiLineEdit_bmp_data, MultiLineEdit_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewMultiLineEdit()),
		       "New QMultiLineEdit (Ctrl+8)", 
		       "Create a new QMultiLineEdit" );
    pixmap.loadFromData( ComboBox_bmp_data, ComboBox_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewComboBox()),
		       "New QComboBox (Ctrl+9)", "Create a new QComboBox" );
    pixmap.loadFromData( ListBox_bmp_data, ListBox_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewListBox()),
		       "New QListBox (Ctrl+0)", "Create a new QListBox" );
    pixmap.loadFromData( ScrollBar_bmp_data, ScrollBar_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewScrollBar()),
		       "New QScrollBar (Alt+1)", 
		       "Create a new QScrollBar" );
    pixmap.loadFromData( Slider_bmp_data, Slider_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewSlider()),
		       "New QSlider (Alt+2)", "Create a new QSlider" );
    pixmap.loadFromData( ProgressBar_bmp_data, ProgressBar_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewProgressBar()),
			     "New QProgressBar (Alt+3)",
			     "Create a new QProgressBar" );
    pixmap.loadFromData( Frame_bmp_data, Frame_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewFrame()),
		       "New QFrame (Alt+4)", "Create a new QFrame" );
    pixmap.loadFromData( MenuBar_bmp_data, MenuBar_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewMenuBar()),
		       "New QMenuBar (Alt+5)", "Create a new QMenuBar" );
    pixmap.loadFromData( User_bmp_data, User_bmp_len );
    itsWidgetToolbar.Insert( pixmap, this, SLOT(NewUser()),
		       "New User Widget (Alt+6)", 
		       "Create a new user defineable widget" );

    connect( &itsWidgetToolbar.GetToolTipGroup(), SIGNAL(showTip(const char*)),
	     SLOT(ShowToolTip(const char*)) );
    connect( &itsWidgetToolbar.GetToolTipGroup(), SIGNAL(removeTip()),
	     SLOT(RemoveToolTip()) );

    // Setup some accelerators

    // Move widgets
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( Key_Up ),
			     itsActLayout, SLOT(MoveUp()) );
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( Key_Down ),
			     itsActLayout, SLOT(MoveDown()) );
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( Key_Left ),
			     itsActLayout, SLOT(MoveLeft()) );
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( Key_Right ),
			     itsActLayout, SLOT(MoveRight()) );
    // Resize widgets
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( SHIFT+Key_Up ),
			     itsActLayout, SLOT(ResizeShorter()) );
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( SHIFT+Key_Down ),
			     itsActLayout, SLOT(ResizeTaller()) );
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( SHIFT+Key_Left ),
			     itsActLayout, SLOT(ResizeNarrower()) );
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( SHIFT+Key_Right ),
			     itsActLayout, SLOT(ResizeWider()) );
    // Get widget properties
    itsKbdAccel.connectItem( itsKbdAccel.insertItem( Key_Return ),
			     itsActLayout, SLOT(SelectedWidgetProperties()) );

    // Setup Layout

    // add toolbar to layout
    itsLayout.addWidget( &itsWidgetToolbar );
    itsWidgetToolbar.setMinimumSize( itsWidgetToolbar.size() );
    //itsAlignToolbar.setMinimumSize( 0, itsAlignToolbar.geometry().height() );  

    itsLayout.addSpacing( 5 );

    // create a new layout to handle horizontal spacing of WidgetFrame
    QBoxLayout* dlgLayout = new QBoxLayout( QBoxLayout::LeftToRight, 5 );
    itsLayout.addLayout( dlgLayout, 1 );

    // set layout of horizontal layout
    //dlgLayout->addSpacing( 5 );
    dlgLayout->addWidget( itsActWidgetWnd, 1, AlignTop );	
    itsActWidgetWnd->setFixedSize( 400, 300 );
    //dlgLayout->addSpacing( 5 );
    dlgLayout->addStretch( 1 );

    itsLayout.addSpacing( 5 );
    itsLayout.addStretch( 1 );

    // setup status bar
    itsStatusMsg = itsStatusBar.InsertTextRegion( 1 );
    itsStatusBar.InsertSpacing( 5 );
    itsStatusPos = itsStatusBar.InsertTextRegion( 0, "X:000 Y:000" );
    itsStatusBar.SetText( itsStatusPos, "X:    Y:   " );
    itsStatusSize = itsStatusBar.InsertTextRegion( 0, "W:000 H:000");
    itsStatusBar.SetText( itsStatusSize, "W:    H:   " );
  
    // add status bar to layout
    itsLayout.addWidget( &itsStatusBar );
    itsStatusBar.setMinimumSize( 0, itsStatusBar.geometry().height() );

    // Start snapping
    itsActWidgetWnd->SetGrid( 10 );

    itsLayout.activate();

    itsActLayout->Start();

    // resize to minimum size
    resize( 0,0 );
}


DialogWnd::~DialogWnd()
{
}

void DialogWnd::resizeEvent
(
    QResizeEvent*	//event
)
{
    itsActWidgetWnd->resize( itsActWidgetWnd->maximumSize() );
    // itsWidgetFrame.setGeometry(QRect( itsWidgetFrame.geometry().topLeft(),
    //			      mapFromParent(geometry().bottomRight()) - QPoint(3,3)));
}


void DialogWnd::closeEvent
(
    QCloseEvent*	event
)
{
  // shut up
  event = event;
      
    emit Closed();
}


int DialogWnd::DoPropertyDialog( void )
{
    DialogPropDialog dlg( itsDialog );
    
    return dlg.exec();
}


void DialogWnd::NewButton()
{
    itsActLayout->AddWidget( DlgWidget::DW_Button );
}


void DialogWnd::NewButtonGroup()
{
    itsActLayout->AddWidget( DlgWidget::DW_ButtonGroup );
}


void DialogWnd::NewCheckBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_CheckBox );
}


void DialogWnd::NewComboBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_ComboBox );
}


void DialogWnd::NewFrame()
{
    itsActLayout->AddWidget( DlgWidget::DW_Frame );
}


void DialogWnd::NewGroupBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_GroupBox );
}


void DialogWnd::NewLCDNumber()
{
    itsActLayout->AddWidget( DlgWidget::DW_LCDNumber );
}


void DialogWnd::NewLabel()
{
    itsActLayout->AddWidget( DlgWidget::DW_Label );
}


void DialogWnd::NewLineEdit()
{
    itsActLayout->AddWidget( DlgWidget::DW_LineEdit );
}


void DialogWnd::NewListBox()
{
    itsActLayout->AddWidget( DlgWidget::DW_ListBox );
}


void DialogWnd::NewMenuBar()
{
    itsActLayout->AddWidget( DlgWidget::DW_MenuBar );
}


void DialogWnd::NewMultiLineEdit()
{
    itsActLayout->AddWidget( DlgWidget::DW_MultiLineEdit );
}


void DialogWnd::NewProgressBar()
{
    itsActLayout->AddWidget( DlgWidget::DW_ProgressBar );
}


void DialogWnd::NewPushButton()
{
    itsActLayout->AddWidget( DlgWidget::DW_PushButton );
}


void DialogWnd::NewRadioButton()
{
    itsActLayout->AddWidget( DlgWidget::DW_RadioButton );
}


void DialogWnd::NewScrollBar()
{
    itsActLayout->AddWidget( DlgWidget::DW_ScrollBar );
}


void DialogWnd::NewSlider()
{
    itsActLayout->AddWidget( DlgWidget::DW_Slider );
}


void DialogWnd::NewUser()
{
    itsActLayout->AddWidget( DlgWidget::DW_User );
}


void DialogWnd::Close()
{
    // Not really closing the dialog here. Masterclass Dialog will hide us 
    // instead
    emit Closed();
}


void DialogWnd::WidgetWndChanged()
{
    itsLayout.activate();
}


void DialogWnd::WidgetGeometryChanged( int x, int y,
				       int width, int height )
{
    QString str;

    str.sprintf( "X:%3d Y:%3d", x, y );
    itsStatusBar.SetText( itsStatusPos, str );

    str.sprintf( "W:%3d H:%3d", width, height );
    itsStatusBar.SetText( itsStatusSize, str );
}


void DialogWnd::WidgetSelected( const QString&	widgetName,
				const QString&	varName )
{
    QString msg = widgetName.copy();

    if( !varName.isEmpty() )
    {
	msg += " (" + varName + ")";
    }

    itsLastStatusMsg = msg;
    itsStatusBar.SetText( itsStatusMsg, msg );

    if( theProjectWnd )
    {
	itsEditMenu->setItemEnabled( cutMenuId, TRUE );
	itsEditMenu->setItemEnabled( copyMenuId, TRUE );

	itsToolbar.EnableItem( itsCutTbId, TRUE );
	itsToolbar.EnableItem( itsCopyTbId, TRUE );
    }
}

void DialogWnd::WidgetDeselected()
{
    itsLastStatusMsg = "";
    itsStatusBar.SetText( itsStatusMsg, itsLastStatusMsg );

    itsEditMenu->setItemEnabled( cutMenuId, FALSE );
    itsEditMenu->setItemEnabled( copyMenuId, FALSE );

    itsToolbar.EnableItem( itsCutTbId, FALSE );
    itsToolbar.EnableItem( itsCopyTbId, FALSE );
}

void DialogWnd::ShowToolTip( const char* tip )
{
    itsStatusBar.SetText( itsStatusMsg, tip );
}


void DialogWnd::RemoveToolTip()
{
    itsStatusBar.SetText( itsStatusMsg, itsLastStatusMsg );
}

void DialogWnd::CPAvailable( bool av )
{
    itsEditMenu->setItemEnabled( pasteMenuId, av );
    itsToolbar.EnableItem( itsPasteTbId, av );
}


void DialogWnd::UpdateScreen( int flags )
{
    bool widgetSelected = FALSE;
    bool align = FALSE;
    bool layout = FALSE;
    bool boxLayout = FALSE;

    if( flags & WidgetLayout::SF_WidgetSelected )
    {
	widgetSelected = TRUE;
    }
    
    if( flags & WidgetLayout::SF_Align )
    {
	align = TRUE;
    }
    
    if( flags & WidgetLayout::SF_Layout )
    {
	layout = TRUE;
    }
    
    if( flags & WidgetLayout::SF_BoxLayout )
    {
	boxLayout = TRUE;
    }

    itsMenu.setItemEnabled( itsEditRaiseMenuId, widgetSelected );
    itsMenu.setItemEnabled( itsEditLowerMenuId, widgetSelected );
    itsMenu.setItemEnabled( itsEditDeleteMenuId, widgetSelected );
    itsMenu.setItemEnabled( itsEditSizeToFitMenuId, widgetSelected );

    itsMenu.setItemEnabled( itsAlignMenuId, align );
    itsMenu.setItemEnabled( itsAlignTopMenuId, align );
    itsMenu.setItemEnabled( itsAlignBottomMenuId, align );
    itsMenu.setItemEnabled( itsAlignLeftMenuId, align );
    itsMenu.setItemEnabled( itsAlignRightMenuId, align );
    itsMenu.setItemEnabled( itsAlignWidthMenuId, align );
    itsMenu.setItemEnabled( itsAlignHeightMenuId, align );
    itsMenu.setItemEnabled( itsAlignSizeMenuId, align );

    itsMenu.setItemEnabled( itsLayoutBoxLayoutMenuId, layout );
//     itsMenu.setItemEnabled( itsLayoutGridLayoutMenuId, layout );
    
    itsMenu.setItemEnabled( itsLayoutSpacingMenuId, boxLayout );
    itsMenu.setItemEnabled( itsLayoutStretchMenuId, boxLayout );

    itsToolbar.EnableItem( itsAlignTopTbId, align );
    itsToolbar.EnableItem( itsAlignBottomTbId, align );
    itsToolbar.EnableItem( itsAlignLeftTbId, align );
    itsToolbar.EnableItem( itsAlignRightTbId, align );
    itsToolbar.EnableItem( itsAlignWidthTbId, align );
    itsToolbar.EnableItem( itsAlignHeightTbId, align );
    itsToolbar.EnableItem( itsAlignSizeTbId, align );

    itsToolbar.EnableItem( itsLayoutBoxLayoutTbId, layout );
//     itsToolbar.EnableItem( itsLayoutGridLayoutTbId, layout );
    
    itsToolbar.EnableItem( itsLayoutSpacingTbId, boxLayout );
    itsToolbar.EnableItem( itsLayoutStretchTbId, boxLayout );
}
