#include "widget/PushButton.h"

#define Inherited QPushButton

PushButton::PushButton
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( widget, name )
{
}


void PushButton::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void PushButton::mouseDoubleClickEvent( QMouseEvent*	event )
{
    emit MouseDoubleClick( this, event );
}


void PushButton::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void PushButton::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void PushButton::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void PushButton::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this, event );
}


void PushButton::moveEvent
(
    QMoveEvent*	event
)
{
    Inherited::moveEvent( event );
    
    emit Move( this, event );
}





