/*
 * File:	wx_win.h
 * Purpose:	
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

/*
 * Purpose:  wxWindow class declaration. Base class for all windows and
 *           panel items.
 */


#ifndef wx_winh
#define wx_winh

#include "wb_win.h"

#include <windows.h>

/*
 * Base class for frame, panel, canvas, panel items, dialog box.
 *
 */

#ifdef IN_CPROTO
typedef       void    *wxWindow ;
#else

class wxWindow: public wxbWindow
{
 public:
  HANDLE ms_handle;                   // For menus and hwnds: using 'handle'
                                      // causes too many compiler messages
  int wxWinType;                      // For knowing how to delete the object
  int cxChar;
  int cyChar;
  int windows_id;
  Bool mouseInWindow ;
  Bool winEnabled;
  virtual BOOL MSWCommand(UINT param, WORD id);
  wxWindow *FindItem(int id);
  virtual void PreDelete(HDC dc);              // Allows system cleanup
  HWND GetHWND(void);

  // Constructors/Destructors
  wxWindow(void);
  virtual ~wxWindow(void);

  virtual void Show(Bool show);
  virtual wxCursor *SetCursor(wxCursor *cursor);
  virtual void SetColourMap(wxColourMap *cmap);

  virtual float GetCharHeight(void);
  virtual float GetCharWidth(void);
  virtual void GetTextExtent(const char *string, float *x, float *y,
                      float *descent = NULL, float *externalLeading = NULL);

  void GetSize(int *width, int *height);
  void GetPosition(int *x, int *y);
  void GetClientSize(int *width, int *height); // Size client can use
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int size);
  void ClientToScreen(int *x, int *y);
  void ScreenToClient(int *x, int *y);
  void SetFocus(void);
  void CaptureMouse(void);
  void ReleaseMouse(void);
  void Enable(Bool enable);
  void DragAcceptFiles(Bool accept);
  inline void SetTitle(char *title) {};
  inline void Fit(void) {};
  inline void Centre(int direction) {};
  Bool PopupMenu(wxMenu *menu, float x, float y);
};

int wxCharCodeMSWToWX(int keySym);
int wxCharCodeWXToMSW(int id);

#endif // IN_CPROTO
#endif
