/* Program tacg - a command line tool for Restriction Enzyme digests of DNA  */
/* Copyright  1996 Harry J Mangalam, University of California, Irvine (mangalam@uci.edu, 714 824 4824) */

/* The use of this software (except that by Harald T. Alvestrand, which is described in 'udping.c')
   is bound by the notice that appears in the file 'tacg.h' which should accompany this file.  In the event 
   that 'tacg.h' is not bundled with this file, please contact the author.
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h> 
#include <stdlib.h>
#include <math.h>
#include "tacg.h" /* contains all the defines, includes, function prototypes for both main() and functions */


/*  PrintGelLadderMap does what it implies - prints a ladder map sort of like the GCG program, but in textmode only
    for now.  It uses the same width specification (-w) that the rest of the output does, and writes output to
    stdout rather than to the files that it did previously.  It has been somewhat munged to provide both a
    Summary map function at the same time and a Pseudo-gel map, as the data that it calculates is common to all these
    functions  */

/*  gel  flag that tells fn() which kind of output is expected: 0 = ladder map, 1 = gel map
    minlog is flag_value [0][7] which if !0 tells fn() that the gel map is wanted and at what log the gel map should start 
*/
/* MAX_LADGEL_WIDTH used as MAX parameter;  actual width will be set from flags via flag_value[0][22] */
/* some changes resulted from porting it to DEC Ultrix - the system on which it was ported had all kinds of broken
        and non-standard libs.  It's sprintf() seemed to be completely broken, so I had to rewrite some lines to avoid 
        using the returned value at all */ 

/* All file specification adn handling has been removed as it now writes to std out, rather than to a file. */

void PrintGelLadderMap(struct RE_struct REStr[], int NumGREs, long seq_len, int *GREs, 
         long *SF_data[MAX_NUM_RES+10], long flag_value[2][NFLAGS], int gel) {

   int   NumSumREs, itmp, m, n, p, i, j, k, Cnt, ladder_cuts[MAX_LADGEL_WIDTH+4], iNumOfDivs, iSpacesPerDiv, 
         Summary_Enz[MAX_NUM_RES], ok2wr[MAX_OUTPUT_LINES], okline, min_okline, max_okline, label_len, 
         p_width, spl, xtra, I_nlogs, minlog;
   long  iBasesPerDiv, li;
   float rBasesPerSpace, rBasesPerDiv, rNumOfDivs, rSpacesPerDiv, rtmp, truval, F_nlogs, log_seq_len, 
         log_frag_siz, fminlog;
   char  ladder_char[MAX_LADGEL_WIDTH+4], number_line[MAX_LADGEL_WIDTH+O_LMARG+4], mark,
         tic_line[MAX_LADGEL_WIDTH+O_LMARG+4],  O_txt[MAX_OUTPUT_LINES][O_RMARG+MAX_BASES_PER_LINE+4];
   char nums[10] = {'0','1','2','3','4','5','6','7','8','9'};

   minlog = (int)flag_value [0][7]; /* for readability */
   fminlog = (float) minlog; /* for readability */

/* set/clear all the common arrays */
   memset(ladder_cuts,0,sizeof (int)* MAX_LADGEL_WIDTH); /* and initialize to 0 */
   memset(number_line,' ',MAX_LADGEL_WIDTH+O_LMARG+2); /* and initialize to spaces/blanks */
   memset(tic_line,' ',MAX_LADGEL_WIDTH+O_LMARG+2); /* and initialize to spaces/blanks */

/* Separate the Gel stuff from the Ladder stuff */   
   if (gel)  { /* for gel map only */
      /* have to calc #s for labeling the axis */
      log_seq_len =  log10 ((float)seq_len);
      F_nlogs = log_seq_len - fminlog;  /* the difference betw start and seq_len */
      I_nlogs =  (int) F_nlogs;
      spl = (int) (flag_value[0][22] / F_nlogs); /* spl = spaces per log */
  /* setting up the tics and numbers */
      li = 10;
      if (minlog == 2) li = 100;
      sprintf(number_line, "%*ld", O_LMARG+1, li);
      for (i=0; i<=I_nlogs; i++) {
         li *= 10;
         if (li <= seq_len) sprintf(number_line+(i*spl+O_LMARG+1), "%*ld", spl, li);
         for (j=1; (j<10 && truval<log_seq_len); j++) {
         truval = (float)i+minlog + log10((float)j);
         Cnt = (i*spl+O_LMARG-1)+(int)(log10((float)(j))* (float)spl + 1.5); 
           if (Cnt<flag_value[0][22]+O_LMARG+2) tic_line[Cnt] = '.';   /* sanity check... */
         }
      }
                tic_line[Cnt+1] = '\0';
      strcat(number_line, "\000");/* to terminate correctly */
      /* And print a minimally descriptive header */
      fprintf(stdout, "\n\n\n  Pseudo-Gel Map of Digestions:  ");
   } else {  /* for ladder map only */
      /* vars, inits for the pretty print summary map */
      p_width = O_LMARG + flag_value[0][22]+O_RMARG;
      /* calc all the vars necessary for the ladder */
      rBasesPerDiv = seq_len / PREFERED_NUM_DIVS;
      iBasesPerDiv = (int) rBasesPerDiv;

      rtmp = rBasesPerDiv;
      for (Cnt=1; rtmp >= 10.0; Cnt++) rtmp = rtmp /10; /* 1st part of finding a suitable div size */
      iBasesPerDiv = (int) (rtmp);
      for (n=1; n<Cnt;n++) iBasesPerDiv *= 10; /* and once found, multiply it back up to the right size */ 

      rNumOfDivs = (float)seq_len / (float)iBasesPerDiv; /* real number of divs to cover whole sequence */ 
      iNumOfDivs = (int) rNumOfDivs; /* truncate the number to get the whole seq covered in the available space */ 

      rSpacesPerDiv = flag_value[0][22] / rNumOfDivs; 
      iSpacesPerDiv = (int) rSpacesPerDiv;

      rBasesPerSpace = (float)iBasesPerDiv / (float)iSpacesPerDiv; 
      memset(ladder_char,'-',MAX_LADGEL_WIDTH); /* initialize to dashes */
      /* calc numbers for the axis */
      for (i=1; i<=iNumOfDivs; i++) { /* fill out number_line with the number markers */
         sprintf(number_line+((i-1)*iSpacesPerDiv + O_LMARG), "%*ld", iSpacesPerDiv, i*iBasesPerDiv);
      }
      strcat(number_line, "\000"); /* and mark it with an end of string */
      for (i=1; i<=iNumOfDivs; i++) memcpy (&tic_line[i*iSpacesPerDiv + O_LMARG - 1], ":", 1);
      tic_line[flag_value[0][22]+O_LMARG+1] = '\000';  /* just to make sure that it ends OK */
      /* Print a minimally descriptive header */
      fprintf(stdout, "\n\n\n  Ladder Map of Restriction Enzyme Cut Sites:  ");
   }

/* need to print the number_line once every 50 iterations and the tics every TIC_REPEAT
   iterations, so yet another level of iffiness is required */
/* COMMON CODE */
/* if minimum cuts (-m) flag has been set */
   if ( flag_value[0][3] != 1) fprintf(stdout, "  *Minimum* Cuts: %ld",  flag_value[0][3]);
/* if maximum (-M) flag has been set */
   if ( flag_value[0][4] != 32000) fprintf(stdout, "  *Maximum* Cuts: %ld", flag_value[0][4] );
   fprintf(stdout, "\n");

   Cnt = 0; NumSumREs=0;
   for (m = 0; m < NumGREs; m++){ 
      if (REStr[GREs[m]].E_Ncuts <= SUMMARY_CUTS) Summary_Enz[NumSumREs++]= GREs[m]; /* gathering REs for Summary map */
      if((REStr[GREs[m]].E_mag   >= flag_value[0][1]) &&    /* E_mag must be >= to -n flag */
         (REStr[GREs[m]].E_Ncuts >= flag_value[0][3]) &&    /* Ncuts >= -m, */
         (REStr[GREs[m]].E_Ncuts <= flag_value[0][4])) {    /* Ncuts <= -M */

         if(((flag_value[0][2] == 1) && (mark = '|')) || /* if want all, only 1st has to be true to short circuit */
            ((REStr[GREs[m]].E_olap > 0) && (flag_value[0][2] == 5)) || /* if olap < 0 && overhang = 5' */
            ((REStr[GREs[m]].E_olap < 0) && (flag_value[0][2] == 3)) || /* if olap > 0 && overhang = 3' */
            ((REStr[GREs[m]].E_olap ==0) && (flag_value[0][2] == 0))) { /* if olap = 0 && overhang = blunt */

            if (REStr[GREs[m]].E_olap > 0) mark = '\\';  /* set up the markers for the output */
            else if (REStr[GREs[m]].E_olap < 0) mark = '/';
         /* if need repeated headers or tics, print them.... */
            if ((Cnt % NUMBERLINE_REPEAT) == 0) fprintf (stdout, "\n%s", number_line);
            if ((Cnt++ % TIC_REPEAT) == 0)      fprintf (stdout, "\n%s", tic_line);
         /* and now the real data... */
            fprintf (stdout, "\n%9s ", REStr[GREs[m]].E_nam); /* print the name of the filtered RE */
         /* calculate where the cut marks go... */
            if (gel)  { /* calc fragment migration via simple log approximation */
                                   memset(ladder_char,' ',MAX_LADGEL_WIDTH); /* and re-initialize to dashes */
                                   mark = '|'; /* reset mark for gel map - no diffs for 5', 3', blunts... */
                                   xtra = REStr[GREs[m]].E_Ncuts;
                                   if (flag_value[0][0] == 1) xtra++; /* for 'xtra' fragment in linear digest */
                                   for (j=0; j<xtra; j++){
                                      if (SF_data[GREs[m]][j]>0)log_frag_siz = log10((float)SF_data[GREs[m]][j]);
                                      if (log_frag_siz <= fminlog) { ladder_cuts[0]++;  /* count the # of frags less than the min shown */
                                      } else {
                                         n = (int) (0.5 + (float)flag_value[0][22] * (log_frag_siz - fminlog)/(log_seq_len - fminlog));  /* debug line */
                                         ladder_cuts[n]++;
                                      }
                                   }
                                } else { /* if it's for the ladder */
                                   memset(ladder_char,'-',MAX_LADGEL_WIDTH); /* and re-initialize to dashes */
                                   for (j=1; j<=REStr[GREs[m]].E_Ncuts; j++) {
                                      ladder_cuts[((int) (0.5 + ((float)SF_data[GREs[m]][j])/rBasesPerSpace)) - 1]++; 
                                   }
                                }
            /* now all the els of ladder_cuts are incr'd for the whole SF_data data, soooo print them out*/
            for (i=0; i<flag_value[0][22]; i++) {
               if (ladder_cuts[i] != 0) {
                  if (ladder_cuts[i] == 1) ladder_char[i] = mark;
                  else {
                    if (ladder_cuts[i] <10) memcpy(&ladder_char[i], &nums[ladder_cuts[i]],1);
                    else {
                       ladder_char[i] = '*';
                    }
                  }
               }
            } /* before printing ladder_char, also have to clear the '-'s that the sequence didn't get to */
            if (!gel) for (i=(int)(0.5 + seq_len/rBasesPerSpace); i<flag_value[0][22]; i++) ladder_char[i] = ' ';
            ladder_char[flag_value[0][22]] = '\000';
            fprintf (stdout, "%*s %4d", flag_value[0][22], ladder_char, REStr[GREs[m]].E_Ncuts); /* and then print it out */
            memset(ladder_cuts,0,sizeof (int)* MAX_LADGEL_WIDTH); /* and re-initialize to 0 */
         }
      }
   }
/* at this point, have indices for all REs that cut <= SUMMARY_CUTS in Summary_Enz[], so can now append the summary.. 
   ladder_cuts, ladder_char are both reset, so can re-use them without further cost */
/* Set up the output..*/
   if (!gel) {  /* conditional for printing the summary map */ 
      memset(ladder_char,'-',MAX_LADGEL_WIDTH); /* and re-initialize to dashes */
      okline = min_okline = O_SEQ_LINE-2; /* set the min (highest on page) line of buffer to print out for Summary map */
      max_okline = O_SEQ_LINE + 3; /* how many more lines beyond dashes are required for output */
      memset(O_txt,' ', (MAX_OUTPUT_LINES * (O_RMARG+MAX_BASES_PER_LINE))); /* and initialize to spaces/blanks */
      for (i=0; i<MAX_OUTPUT_LINES; i++) ok2wr[i] = O_LMARG; /* set/reset all of ok2wr to O_LMARG for the new block*/
      /* before printing ladder_char, also have to clear the '-'s that the sequence didn't get to */
      for (i=(int)(0.5 + seq_len/rBasesPerSpace); i<flag_value[0][22]; i++) ladder_char[i] = ' ';

      fprintf(stdout, "\n\n\n\nSummary of Enzymes that cut ** %d ** times or less:\n\n\n", SUMMARY_CUTS);
      memcpy(&O_txt[O_SEQ_LINE][0], &ladder_char, flag_value[0][22]); /* copy the dashes into place */
      memcpy(&O_txt[O_SEQ_LINE+1][0], &tic_line[O_LMARG], flag_value[0][22]); /* copy the marker line into place */
      memcpy(&O_txt[O_SEQ_LINE+2][0], &number_line[O_LMARG], flag_value[0][22]); /* copy the numbers into place */
      /* calculate where the cut marks go... */
      for (i=0; i<NumSumREs; i++) {    /* while there's still more REs to go thru */
         strcpy (ladder_char, REStr[Summary_Enz[i]].E_nam);
         strcat (ladder_char, "@"); /* common for all cuts with this enz - next place to copy is at E_nam_l+1 */
         for (j=1;j<=REStr[Summary_Enz[i]].E_Ncuts; j++) {      /* while there's still more cuts to go thru */
                                /* finish composing the marker name, using number_line, since we don't need it anymore  */
            memset(number_line,' ',MAX_LADGEL_WIDTH+O_LMARG);  /* initialize to spaces/blanks */
            sprintf(number_line, "%d", SF_data[Summary_Enz[i]][j]); /* finish composing name by adding cut position  */
                                itmp = strlen(number_line); /* stupid Ultrix segfaults on itmp = sprintf(); this is the alternative*/
            memcpy(&ladder_char[REStr[Summary_Enz[i]].E_nam_l+1], &number_line, itmp+1); /* has no str termination tho */
            label_len = strlen(ladder_char);
            itmp = ((int) (0.5 + ((float)SF_data[Summary_Enz[i]][j])/rBasesPerSpace)) - 1; /* where the cut maps to */
            O_txt[O_SEQ_LINE-1][itmp] = '|';   /* write the 'cut' indicator on the line above dashes */
            /* locate the position for writing the name */
            while (itmp < ok2wr[okline]) okline--; /* then go up to the lowest 'free' line */
            if (okline != O_SEQ_LINE-2)  { /* but if can't place the name on the lowest line.. */
               p = O_SEQ_LINE-1; k = 0;   /* then check if there's any space lower between previous names */
               /* following 'while' must be ordered like it is - p will be decr only if k == 0 */
               while (k == 0 && --p != okline) { /* leaving 1 space before and after the name */
                  if (O_txt[p][itmp-1] == ' '         &&     /* this can be replaced with something */
                      O_txt[p][itmp+label_len] == ' ' &&     /* more efficient later */
                      O_txt[p][itmp+4] == ' '         &&     /* must check for a space here..- this one might not be nec. */               
                      O_txt[p][itmp+5] == ' ' )  k = 1;      /* as well as here */
               }
               okline = p; /* p = vertical counter ~= okline, k = 1 when we find enuf space */
            }

            /* and memcpy the RE label from the struct to the output array */
            memcpy (&O_txt[okline][itmp],&ladder_char, label_len); /* don't want the NULL term if it gets to here!! */
            /* and incr the ok2wr posn for that line by the length of the RE name + 1 */
            /* 'ok2wr[okline]' below is modified only if we didn't find any lower spaces */
            if (itmp + label_len + 1 > ok2wr[okline])  ok2wr[okline] = itmp + label_len + 1; 
            if (okline < min_okline) min_okline = okline;
         }     /* for (j=1;j<=REStr[Summary_Enz[i]].E_Ncuts; j++) .. */
      }   /* for (i=0; i<NumSumREs; i++) ... */
      /* Now print out the block we've composed, from min_okline to max_okline */ 
      for (i=min_okline; i<max_okline;i++) { fprintf(stdout, "%.*s\n",p_width,O_txt[i]); } 
      /* And clean out the lines written into O_txt as well */ 
      memset(O_txt,' ',((O_RMARG + MAX_BASES_PER_LINE) * MAX_OUTPUT_LINES)); /* set all of O_txt to blanks */ 
   } /*if (!gel) ... */
          fprintf(stdout,"\n");     /* make sure the output ends with a newline */
} /*  end of  PrintLadderMap() */



/* PrintSitesFrags prints out the fragments either sorted or unsorted, depending on whether the array has been sorted - 
   it doesn't care, it just prints whatever's in the array nicely */
/* sites       indicator for whether the fn() should do site data (1) or fragment data (0)
*/
void PrintSitesFrags(struct RE_struct REStr[],int NumGREs, int reps, int *GREs, long *SF_data[], 
                     long flag_value[2][NFLAGS], int sites) {
  int i, j, k, l, m, xtra;
  char *names[] =  {"Fragment Size", "Cut Site", "Fragment", "Cut"};
   if (sites) fprintf(stdout, "\n\n\n");
   fprintf(stdout, "  ** %ss by Restriction Enzyme **", names[sites]);
   if ( flag_value[0][3] != 1) {  /* if minimum cuts (-m) flag has been set */
        fprintf(stdout, "   *Minimum* Cuts: %ld",  flag_value[0][3]);
   }
   if ( flag_value[0][4] != 32000) {  /* if maximum (-M) flag has been set */
      fprintf(stdout, "   *Maximum* Cuts: %ld", flag_value[0][4] );
   }
   fprintf(stdout, "\n\n");
   for (m = 0; m < NumGREs; m++){
      if((REStr[GREs[m]].E_mag >= flag_value[0][1]) &&      /* E_mag must be >= to -n flag */
         (REStr[GREs[m]].E_Ncuts >= flag_value[0][3]) &&    /* Ncuts >= -m, */
         (REStr[GREs[m]].E_Ncuts <= flag_value[0][4])) {    /* Ncuts <= -M */
         if ((flag_value[0][2] == 1) || /* if want to print them all, only this has to be true to short circuit */
            ((REStr[GREs[m]].E_olap > 0) && (flag_value[0][2] == 5)) || /* if olap < 0 && overhang = 5' */
            ((REStr[GREs[m]].E_olap < 0) && (flag_value[0][2] == 3)) || /* if olap > 0 && overhang = 3' */
            ((REStr[GREs[m]].E_olap ==0) && (flag_value[0][2] == 0))) { /* if olap = 0 && overhang = blunt */

            /* this 'xtra' stuff handles the topo differences (linear has an extra fragment), */
            xtra = REStr[GREs[m]].E_Ncuts;      /* assign xtra to # cuts */
            if (sites == 0 && flag_value[0][0] == 1) xtra++; /* if frags && topo is linear, # frags will be Ncuts+1 */
            fprintf (stdout, "\n%-10s  %s - %d %s(s)\n", REStr[GREs[m]].E_nam, REStr[GREs[m]].E_raw_sit, xtra,
                                names[sites+2]);
            l = (int)((xtra/reps)+1);
            i=0;
            if (sites){ i = 1; xtra++;}  /* for the difference between how the arrays are organized */
            for (k=0;k<l;k++){
               for (j=0;j<reps && i<xtra;j++,i++) fprintf(stdout, "%7ld",SF_data[GREs[m]][i]);
               fprintf(stdout, "\n" );
            }
         }
      }
   }
}                 
